/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.block.BigDripleafBlock;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BigDripleafFeature
extends Feature<NoFeatureConfig> {
    public BigDripleafFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        return BigDripleafFeature.generate(worldIn, rand, pos, 4, 2, 4);
    }

    public static boolean generate(IWorld worldIn, Random rand, BlockPos pos, int maxValue, int minValue, int maxLength) {
        if (BigDripleafFeature.isInvalidPlacementLocation(worldIn, pos)) {
            return false;
        }
        BigDripleafFeature.placeBigDripleaf(worldIn, rand, pos, maxValue, minValue, maxLength);
        return true;
    }

    private static void placeBigDripleaf(IWorld worldIn, Random rand, BlockPos pos, int maxValue, int minValue, int maxLength) {
        BlockPos.Mutable validPosition = new BlockPos.Mutable();
        for (int i = 0; i < maxValue * maxValue; ++i) {
            validPosition.func_189533_g((Vec3i)pos).func_196234_d(MathHelper.func_76136_a((Random)rand, (int)(-maxValue), (int)maxValue), MathHelper.func_76136_a((Random)rand, (int)(-minValue), (int)minValue), MathHelper.func_76136_a((Random)rand, (int)(-maxValue), (int)maxValue));
            if (!BigDripleafFeature.findFirstAirBlockAboveGround(worldIn, validPosition) || BigDripleafFeature.isInvalidPlacementLocation(worldIn, (BlockPos)validPosition)) continue;
            int length = MathHelper.func_76136_a((Random)rand, (int)1, (int)maxLength);
            if (rand.nextInt(4) == 0) {
                length *= 2;
            }
            if (rand.nextInt(3) == 0) {
                length = 1;
            }
            BigDripleafFeature.placeBigDripleafColumn(worldIn, validPosition, length, Direction.Plane.HORIZONTAL.func_179518_a(rand));
        }
    }

    private static boolean findFirstAirBlockAboveGround(IWorld worldIn, BlockPos.Mutable pos) {
        do {
            pos.func_196234_d(0, -1, 0);
            if (!World.func_189509_E((BlockPos)pos)) continue;
            return false;
        } while (worldIn.func_180495_p((BlockPos)pos).func_196958_f());
        pos.func_196234_d(0, 1, 0);
        return true;
    }

    private static void placeBigDripleafColumn(IWorld worldIn, BlockPos.Mutable pos, int length, Direction direction) {
        for (int i = 0; i <= length; ++i) {
            if (worldIn.func_175623_d((BlockPos)pos)) {
                if (i == length || !worldIn.func_175623_d(pos.func_177984_a())) {
                    worldIn.func_180501_a((BlockPos)pos, (BlockState)((BlockState)((Block)CCBBlocks.BIG_DRIPLEAF.get()).func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BigDripleafBlock.field_185512_D, (Comparable)direction), 2);
                    break;
                }
                worldIn.func_180501_a((BlockPos)pos, (BlockState)((Block)CCBBlocks.BIG_DRIPLEAF_STEM.get()).func_176223_P().func_206870_a((IProperty)BigDripleafBlock.field_185512_D, (Comparable)direction), 2);
            }
            pos.func_189536_c(Direction.UP);
        }
    }

    private static boolean isInvalidPlacementLocation(IWorld worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos)) {
            return true;
        }
        BlockState baseState = worldIn.func_180495_p(pos.func_177977_b());
        return !baseState.func_177230_c().equals(Blocks.field_150348_b) && !baseState.func_177230_c().equals(Blocks.field_196656_g) && !baseState.func_177230_c().equals(Blocks.field_196654_e) && !baseState.func_177230_c().equals(Blocks.field_196650_c) && !baseState.func_177230_c().equals(Blocks.field_150346_d) && !baseState.func_177230_c().equals(Blocks.field_150435_aG) && !baseState.func_177230_c().equals(CCBBlocks.ROOTED_DIRT.get()) && !baseState.func_177230_c().equals(CCBBlocks.MOSS_BLOCK.get());
    }
}

