/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.block.CaveVinesBodyBlock;
import com.blackgear.cavesandcliffs.common.block.CaveVinesHeadBlock;
import com.blackgear.cavesandcliffs.common.util.math.BlockPosHelper;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CaveVineFeature
extends Feature<NoFeatureConfig> {
    public CaveVineFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!worldIn.func_175623_d(pos)) {
            return false;
        }
        this.generateCaveVinesInArea(worldIn, rand, pos);
        return true;
    }

    private void generateCaveVinesInArea(IWorld worldIn, Random rand, BlockPos pos) {
        BlockPos.Mutable validPos = new BlockPos.Mutable();
        for (int i = 0; i < 100; ++i) {
            BlockState baseState;
            BlockPosHelper.setAndOffset(validPos, (Vec3i)pos, rand.nextInt(8) - rand.nextInt(8), rand.nextInt(2) - rand.nextInt(7), rand.nextInt(8) - rand.nextInt(8));
            if (!worldIn.func_175623_d((BlockPos)validPos) || !(baseState = worldIn.func_180495_p(validPos.func_177984_a())).func_177230_c().equals(Blocks.field_150348_b) && !baseState.func_177230_c().equals(Blocks.field_196656_g) && !baseState.func_177230_c().equals(Blocks.field_196654_e) && !baseState.func_177230_c().equals(Blocks.field_196650_c) && !baseState.func_177230_c().equals(Blocks.field_150346_d) && !baseState.func_177230_c().equals(Blocks.field_150435_aG) && !baseState.func_177230_c().equals(CCBBlocks.ROOTED_DIRT.get()) && !baseState.func_177230_c().equals(CCBBlocks.MOSS_BLOCK.get())) continue;
            int length = MathHelper.func_76136_a((Random)rand, (int)1, (int)8);
            if (rand.nextInt(6) == 0) {
                length *= 2;
            }
            if (rand.nextInt(5) == 0) {
                length = 1;
            }
            CaveVineFeature.placeCaveVinesColumn(worldIn, rand, validPos, length, 17, 25);
        }
    }

    private static void placeCaveVinesColumn(IWorld worldIn, Random rand, BlockPos.Mutable pos, int length, int minAge, int maxAge) {
        for (int i = 0; i <= length; ++i) {
            if (worldIn.func_175623_d((BlockPos)pos)) {
                if (i == length || !worldIn.func_175623_d(pos.func_177977_b())) {
                    worldIn.func_180501_a((BlockPos)pos, (BlockState)((BlockState)((Block)CCBBlocks.CAVE_VINES_HEAD.get()).func_176223_P().func_206870_a((IProperty)CaveVinesHeadBlock.AGE, (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)rand, (int)minAge, (int)maxAge)))).func_206870_a((IProperty)CaveVinesHeadBlock.BERRIES, (Comparable)Boolean.valueOf(rand.nextBoolean())), 2);
                    break;
                }
                worldIn.func_180501_a((BlockPos)pos, (BlockState)((Block)CCBBlocks.CAVE_VINES_BODY.get()).func_176223_P().func_206870_a((IProperty)CaveVinesBodyBlock.BERRIES, (Comparable)Boolean.valueOf(rand.nextBoolean())), 2);
            }
            pos.func_189536_c(Direction.DOWN);
        }
    }
}

