/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.util.math.UniformFloat;
import com.blackgear.cavesandcliffs.common.util.math.UniformInt;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class DripstoneClusterConfig
implements IFeatureConfig {
    public final int floorToCeilingSearchRange;
    public final UniformInt height;
    public final UniformInt radius;
    public final int maxStalagmiteStalactiteHeightDiff;
    public final int heightDeviation;
    public final UniformInt dripstoneBlockLayerThickness;
    public final UniformFloat density;
    public final UniformFloat wetness;
    public final float wetnessMean;
    public final float wetnessDeviation;
    public final float chanceOfDripstoneColumnAtMaxDistanceFromCenter;
    public final int maxDistanceFromCenterAffectingChanceOfDripstoneColumn;
    public final int maxDistanceFromCenterAffectingHeightBias;

    public DripstoneClusterConfig(int floorToCeilingSearchRange, UniformInt height, UniformInt radius, int maxStalagmiteStalactiteHeightDiff, int heightDeviation, UniformInt dripstoneBlockLayerThickness, UniformFloat density, UniformFloat wetness, float wetnessMean, float wetnessDeviation, float chanceOfDripstoneColumnAtMaxDistanceFromCenter, int maxDistanceFromCenterAffectingChanceOfDripstoneColumn, int maxDistanceFromCenterAffectingHeightBias) {
        this.floorToCeilingSearchRange = floorToCeilingSearchRange;
        this.height = height;
        this.radius = radius;
        this.maxStalagmiteStalactiteHeightDiff = maxStalagmiteStalactiteHeightDiff;
        this.heightDeviation = heightDeviation;
        this.dripstoneBlockLayerThickness = dripstoneBlockLayerThickness;
        this.density = density;
        this.wetness = wetness;
        this.wetnessMean = wetnessMean;
        this.wetnessDeviation = wetnessDeviation;
        this.chanceOfDripstoneColumnAtMaxDistanceFromCenter = chanceOfDripstoneColumnAtMaxDistanceFromCenter;
        this.maxDistanceFromCenterAffectingChanceOfDripstoneColumn = maxDistanceFromCenterAffectingChanceOfDripstoneColumn;
        this.maxDistanceFromCenterAffectingHeightBias = maxDistanceFromCenterAffectingHeightBias;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("floor_to_ceiling_search_range"), ops.createInt(this.floorToCeilingSearchRange));
        builder.put(ops.createString("height"), this.height.func_218175_a(ops));
        builder.put(ops.createString("radius"), this.radius.func_218175_a(ops));
        builder.put(ops.createString("max_stalagmite_stalactite_height_diff"), ops.createInt(this.maxStalagmiteStalactiteHeightDiff));
        builder.put(ops.createString("height_deviation"), ops.createInt(this.heightDeviation));
        builder.put(ops.createString("dripstone_block_layer_thickness"), this.dripstoneBlockLayerThickness.func_218175_a(ops));
        builder.put(ops.createString("density"), this.density.func_218175_a(ops));
        builder.put(ops.createString("wetness"), this.wetness.func_218175_a(ops));
        builder.put(ops.createString("wetness_mean"), ops.createDouble((double)this.wetnessMean));
        builder.put(ops.createString("wetness_deviation"), ops.createDouble((double)this.wetnessDeviation));
        builder.put(ops.createString("chance_of_dripstone_column_at_max_distance_from_center"), ops.createDouble((double)this.chanceOfDripstoneColumnAtMaxDistanceFromCenter));
        builder.put(ops.createString("max_distance_from_center_affecting_chance_of_dripstone_column"), ops.createInt(this.maxDistanceFromCenterAffectingChanceOfDripstoneColumn));
        builder.put(ops.createString("max_distance_from_center_affecting_height_bias"), ops.createInt(this.maxDistanceFromCenterAffectingHeightBias));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    public static <T> DripstoneClusterConfig deserialize(Dynamic<T> ops) {
        int floorToCeilingSearchRange = ops.get("floor_to_ceiling_search_range").asInt(0);
        UniformInt height = UniformInt.deserialize(ops.get("height").orElseEmptyList());
        UniformInt radius = UniformInt.deserialize(ops.get("radius").orElseEmptyList());
        int maxStalagmiteStalactiteHeightDiff = ops.get("max_stalagmite_stalactite_height_diff").asInt(0);
        int heightDeviation = ops.get("height_deviation").asInt(0);
        UniformInt dripstoneBlockLayerThickness = UniformInt.deserialize(ops.get("dripstone_block_layer_thickness").orElseEmptyList());
        UniformFloat density = UniformFloat.deserialize(ops.get("density").orElseEmptyList());
        UniformFloat wetness = UniformFloat.deserialize(ops.get("wetness").orElseEmptyList());
        float wetnessMean = ops.get("wetness_mean").asFloat(0.0f);
        float wetnessDeviation = ops.get("wetness_deviation").asFloat(0.0f);
        float chanceOfDripstoneColumnAtMaxDistanceFromCenter = ops.get("chance_of_dripstone_column_at_max_distance_from_center").asFloat(0.0f);
        int maxDistanceFromCenterAffectingChanceOfDripstoneColumn = ops.get("max_distance_from_center_affecting_chance_of_dripstone_column").asInt(0);
        int maxDistanceFromCenterAffectingHeightBias = ops.get("max_distance_from_center_affecting_height_bias").asInt(0);
        return new DripstoneClusterConfig(floorToCeilingSearchRange, height, radius, maxStalagmiteStalactiteHeightDiff, heightDeviation, dripstoneBlockLayerThickness, density, wetness, wetnessMean, wetnessDeviation, chanceOfDripstoneColumnAtMaxDistanceFromCenter, maxDistanceFromCenterAffectingChanceOfDripstoneColumn, maxDistanceFromCenterAffectingHeightBias);
    }
}

