/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.tags.CCBBlockTags;
import com.blackgear.cavesandcliffs.common.util.math.CCBMathHelper;
import com.blackgear.cavesandcliffs.common.world.gen.Column;
import com.blackgear.cavesandcliffs.common.world.gen.feature.DripstoneClusterConfig;
import com.blackgear.cavesandcliffs.common.world.gen.feature.DripstoneUtils;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;

public class DripstoneClusterFeature
extends Feature<DripstoneClusterConfig> {
    public DripstoneClusterFeature(Function<Dynamic<?>, ? extends DripstoneClusterConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, DripstoneClusterConfig config) {
        if (!DripstoneUtils.isEmptyOrWater(worldIn, pos)) {
            return false;
        }
        int height = config.height.sample(rand);
        float wetness = DripstoneClusterFeature.randomBetweenBiased(rand, config.wetness.getBaseValue(), config.wetness.getMaxValue(), config.wetnessMean, config.wetnessDeviation);
        float density = config.density.sample(rand);
        int XRadius = config.radius.sample(rand);
        int ZRadius = config.radius.sample(rand);
        for (int x = -XRadius; x <= XRadius; ++x) {
            for (int z = -ZRadius; z <= ZRadius; ++z) {
                double chance = this.getChanceOfStalagmiteOrStalactite(XRadius, ZRadius, x, z, config);
                BlockPos offset = pos.func_177982_a(x, 0, z);
                this.placeColumn(worldIn, rand, offset, x, z, wetness, chance, height, density, config);
            }
        }
        return true;
    }

    private void placeColumn(IWorld worldIn, Random rand, BlockPos pos, int x, int z, float wetness, double chance, int height, float density, DripstoneClusterConfig config) {
        Optional<Column> optionalColumn = Column.scan((IWorldGenerationReader)worldIn, pos, config.floorToCeilingSearchRange, DripstoneUtils::isEmptyOrWater, DripstoneUtils::isDripstoneBaseOrLava);
        if (optionalColumn.isPresent()) {
            OptionalInt columnCeiling = optionalColumn.get().getCeiling();
            OptionalInt columnFloor = optionalColumn.get().getFloor();
            if (columnCeiling.isPresent() || columnFloor.isPresent()) {
                boolean shouldMerge;
                int ceilingDripstoneThickness;
                int floorDripstoneThickness;
                boolean floorDistanceChance;
                int floorY;
                int ceilingY;
                boolean ceilingDripstoneChance;
                Column column;
                boolean shouldPlacePool;
                boolean bl = shouldPlacePool = rand.nextFloat() < wetness;
                if (shouldPlacePool && columnFloor.isPresent() && this.canPlacePool(worldIn, this.atY(pos, columnFloor.getAsInt()))) {
                    int floorHeight = columnFloor.getAsInt();
                    column = optionalColumn.get().withFloor(OptionalInt.of(floorHeight - 1));
                    worldIn.func_180501_a(this.atY(pos, floorHeight), Blocks.field_150355_j.func_176223_P(), 2);
                } else {
                    column = optionalColumn.get();
                }
                OptionalInt floor = column.getFloor();
                boolean bl2 = ceilingDripstoneChance = rand.nextDouble() < chance;
                if (columnCeiling.isPresent() && ceilingDripstoneChance && this.isLava((IWorldReader)worldIn, this.atY(pos, columnCeiling.getAsInt()))) {
                    ceilingY = config.dripstoneBlockLayerThickness.sample(rand);
                    this.replaceBlocksWithDripstoneBlocks(worldIn, this.atY(pos, columnCeiling.getAsInt()), ceilingY, Direction.UP);
                    int dripstoneHeight = floor.isPresent() ? Math.min(height, columnCeiling.getAsInt() - floor.getAsInt()) : height;
                    floorY = this.getDripstoneHeight(rand, x, z, density, dripstoneHeight, config);
                } else {
                    floorY = 0;
                }
                boolean bl3 = floorDistanceChance = rand.nextDouble() < chance;
                if (floor.isPresent() && floorDistanceChance && this.isLava((IWorldReader)worldIn, this.atY(pos, floor.getAsInt()))) {
                    floorDripstoneThickness = config.dripstoneBlockLayerThickness.sample(rand);
                    this.replaceBlocksWithDripstoneBlocks(worldIn, this.atY(pos, floor.getAsInt()), floorDripstoneThickness, Direction.DOWN);
                    ceilingY = Math.max(0, floorY + CCBMathHelper.randomBetweenInclusive(rand, -config.maxStalagmiteStalactiteHeightDiff, config.maxStalagmiteStalactiteHeightDiff));
                } else {
                    ceilingY = 0;
                }
                if (columnCeiling.isPresent() && floor.isPresent() && columnCeiling.getAsInt() - floorY <= floor.getAsInt() + ceilingY) {
                    int floorDistance = floor.getAsInt();
                    int ceilingDistance = columnCeiling.getAsInt();
                    int maxDistance = Math.max(ceilingDistance - floorY, floorDistance + 1);
                    int minDistance = Math.min(floorDistance + ceilingY, ceilingDistance - 1);
                    int dripstoneSize = CCBMathHelper.randomBetweenInclusive(rand, maxDistance, minDistance + 1);
                    int dripstoneBase = dripstoneSize - 1;
                    floorDripstoneThickness = ceilingDistance - dripstoneSize;
                    ceilingDripstoneThickness = dripstoneBase - floorDistance;
                } else {
                    floorDripstoneThickness = floorY;
                    ceilingDripstoneThickness = ceilingY;
                }
                boolean bl4 = shouldMerge = rand.nextBoolean() && floorDripstoneThickness > 0 && ceilingDripstoneThickness > 0 && column.getHeight().isPresent() && floorDripstoneThickness + ceilingDripstoneThickness == column.getHeight().getAsInt();
                if (columnCeiling.isPresent()) {
                    DripstoneUtils.growPointedDripstone(worldIn, this.atY(pos, columnCeiling.getAsInt() - 1), Direction.DOWN, floorDripstoneThickness, shouldMerge);
                }
                if (floor.isPresent()) {
                    DripstoneUtils.growPointedDripstone(worldIn, this.atY(pos, floor.getAsInt() + 1), Direction.UP, ceilingDripstoneThickness, shouldMerge);
                }
            }
        }
    }

    public BlockPos atY(BlockPos pos, int y) {
        return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
    }

    private boolean isLava(IWorldReader worldIn, BlockPos pos) {
        return !worldIn.func_180495_p(pos).func_177230_c().equals(Blocks.field_150353_l);
    }

    private int getDripstoneHeight(Random rand, int x, int z, float density, int dripstoneHeight, DripstoneClusterConfig config) {
        if (rand.nextFloat() > density) {
            return 0;
        }
        int radius = Math.abs(x) + Math.abs(z);
        float height = (float)CCBMathHelper.clampedMap(radius, 0.0, config.maxDistanceFromCenterAffectingHeightBias, (double)dripstoneHeight / 2.0, 0.0);
        return (int)DripstoneClusterFeature.randomBetweenBiased(rand, 0.0f, dripstoneHeight, height, config.heightDeviation);
    }

    private boolean canPlacePool(IWorld worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        if (!(state.func_177230_c().equals(Blocks.field_150355_j) || state.func_177230_c().equals(CCBBlocks.DRIPSTONE_BLOCK.get()) || state.func_177230_c().equals(CCBBlocks.POINTED_DRIPSTONE.get()))) {
            Direction direction;
            Iterator directionIterator = Direction.Plane.HORIZONTAL.iterator();
            do {
                if (directionIterator.hasNext()) continue;
                return this.canBeNextToWater(worldIn, pos.func_177977_b());
            } while (this.canBeNextToWater(worldIn, pos.func_177972_a(direction = (Direction)directionIterator.next())));
        }
        return false;
    }

    private boolean canBeNextToWater(IWorld worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        return state.func_203425_a(CCBBlockTags.BASE_STONE_OVERWORLD) || state.func_204520_s().func_206884_a(FluidTags.field_206959_a);
    }

    private void replaceBlocksWithDripstoneBlocks(IWorld worldIn, BlockPos pos, int length, Direction direction) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(pos);
        for (int i = 0; i < length; ++i) {
            if (!DripstoneUtils.placeDripstoneBlockIfPossible(worldIn, (BlockPos)mutablePos)) {
                return;
            }
            mutablePos.func_189536_c(direction);
        }
    }

    private double getChanceOfStalagmiteOrStalactite(int xRadius, int zRadius, int x, int z, DripstoneClusterConfig config) {
        int getX = xRadius - Math.abs(x);
        int getZ = zRadius - Math.abs(z);
        int minRadius = Math.min(getX, getZ);
        return CCBMathHelper.clampedMap(minRadius, 0.0, config.maxDistanceFromCenterAffectingChanceOfDripstoneColumn, config.maxDistanceFromCenterAffectingChanceOfDripstoneColumn, 1.0);
    }

    private static float randomBetweenBiased(Random rand, float y, float dripstoneHeight, float height, float heightDeviation) {
        return MathHelper.func_76131_a((float)CCBMathHelper.normal(rand, height, heightDeviation), (float)y, (float)dripstoneHeight);
    }
}

