/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.block.PointedDripstoneBlock;
import com.blackgear.cavesandcliffs.common.state.properties.DripstoneThickness;
import com.blackgear.cavesandcliffs.common.tags.CCBBlockTags;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class DripstoneUtils {
    protected static double getDripstoneHeight(double radius, double scale, double heightScale, double bluntness) {
        if (radius < bluntness) {
            radius = bluntness;
        }
        double i = radius / scale * 0.384;
        double j = 0.75 * Math.pow(i, 1.3333333333333333);
        double k = Math.pow(i, 0.6666666666666666);
        double l = 0.3333333333333333 * Math.log(i);
        double m = heightScale * (j - k - l);
        m = Math.max(m, 0.0);
        return m / 0.384 * scale;
    }

    protected static boolean isCircleMostlyEmbeddedInStone(IWorld worldIn, BlockPos pos, int height) {
        if (DripstoneUtils.isEmptyOrWater(worldIn, pos)) {
            return false;
        }
        float radius = 6.0f / (float)height;
        for (float i = 0.0f; i < (float)Math.PI * 2; i += radius) {
            int z;
            int x = (int)(Math.cos(i) * (double)height);
            if (!DripstoneUtils.isEmptyOrWater(worldIn, pos.func_177982_a(x, 0, z = (int)(Math.sin(i) * (double)height)))) continue;
            return false;
        }
        return true;
    }

    protected static boolean isEmptyOrWater(IWorld worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, DripstoneUtils::isEmptyOrWater);
    }

    protected static boolean isEmptyOrWaterOrLava(IWorld worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, DripstoneUtils::isEmptyOrWaterOrLava);
    }

    protected static void buildBaseToTipColumn(Direction direction, int length, boolean isMerged, Consumer<BlockState> consumer) {
        if (length >= 3) {
            consumer.accept(DripstoneUtils.createPointedDripstone(direction, DripstoneThickness.BASE));
            for (int i = 0; i < length - 3; ++i) {
                consumer.accept(DripstoneUtils.createPointedDripstone(direction, DripstoneThickness.MIDDLE));
            }
        }
        if (length >= 2) {
            consumer.accept(DripstoneUtils.createPointedDripstone(direction, DripstoneThickness.FRUSTUM));
        }
        if (length >= 1) {
            consumer.accept(DripstoneUtils.createPointedDripstone(direction, isMerged ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    protected static void growPointedDripstone(IWorld worldIn, BlockPos pos, Direction direction, int length, boolean isMerged) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(pos);
        DripstoneUtils.buildBaseToTipColumn(direction, length, isMerged, state -> {
            if (state.func_177230_c().equals(CCBBlocks.POINTED_DRIPSTONE.get())) {
                state = (BlockState)state.func_206870_a((IProperty)PointedDripstoneBlock.WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.func_201671_F((BlockPos)mutablePos)));
            }
            worldIn.func_180501_a((BlockPos)mutablePos, state, 2);
            mutablePos.func_189536_c(direction);
        });
    }

    protected static boolean placeDripstoneBlockIfPossible(IWorld worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        if (state.func_203425_a(CCBBlockTags.DRIPSTONE_REPLACEABLE)) {
            worldIn.func_180501_a(pos, ((Block)CCBBlocks.DRIPSTONE_BLOCK.get()).func_176223_P(), 2);
            return true;
        }
        return false;
    }

    private static BlockState createPointedDripstone(Direction direction, DripstoneThickness thickness) {
        return (BlockState)((BlockState)((Block)CCBBlocks.POINTED_DRIPSTONE.get()).func_176223_P().func_206870_a((IProperty)PointedDripstoneBlock.TIP_DIRECTION, (Comparable)direction)).func_206870_a(PointedDripstoneBlock.THICKNESS, (Comparable)((Object)thickness));
    }

    public static boolean isDripstoneBaseOrLava(BlockState state) {
        return DripstoneUtils.isDripstoneBase(state) || state.func_177230_c().equals(Blocks.field_150353_l);
    }

    public static boolean isDripstoneBase(BlockState state) {
        return state.func_177230_c().equals(CCBBlocks.DRIPSTONE_BLOCK.get()) || state.func_203425_a(CCBBlockTags.DRIPSTONE_REPLACEABLE);
    }

    public static boolean isEmptyOrWater(BlockState state) {
        return state.func_196958_f() || state.func_177230_c().equals(Blocks.field_150355_j);
    }

    public static boolean isEmptyOrWaterOrLava(BlockState state) {
        return state.func_196958_f() || state.func_177230_c().equals(Blocks.field_150355_j) || state.func_177230_c().equals(Blocks.field_150353_l);
    }
}

