/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.world.gen.GeodeBlockSettings;
import com.blackgear.cavesandcliffs.common.world.gen.GeodeCrackSettings;
import com.blackgear.cavesandcliffs.common.world.gen.GeodeLayerSettings;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class GeodeFeatureConfig
implements IFeatureConfig {
    public final GeodeBlockSettings geodeBlockSettings;
    public final GeodeLayerSettings geodeLayerSettings;
    public final GeodeCrackSettings geodeCrackSettings;
    public final double usePotentialPlacementsChance;
    public final double useAlternateLayerChance;
    public final boolean placementsRequireLayerAlternate;
    public final int minOuterWallDistance;
    public final int maxOuterWallDistance;
    public final int minDistributionPoints;
    public final int maxDistributionPoints;
    public final int minPointOffset;
    public final int maxPointOffset;
    public final int minGenOffset;
    public final int maxGenOffset;
    public final double noiseMultiplier;

    public GeodeFeatureConfig(GeodeBlockSettings blockSettings, GeodeLayerSettings layerSettings, GeodeCrackSettings crackSettings, double placementChance, double alternateLayerChance, boolean requireLayerAlternate, int minOuterWallDistance, int maxOuterWallDistance, int minDistributionPoints, int maxDistributionPoints, int minPointsOffset, int maxPointsOffset, int minGenOffset, int maxGenOffset, double noiseMultiplier) {
        this.geodeBlockSettings = blockSettings;
        this.geodeLayerSettings = layerSettings;
        this.geodeCrackSettings = crackSettings;
        this.usePotentialPlacementsChance = placementChance;
        this.useAlternateLayerChance = alternateLayerChance;
        this.placementsRequireLayerAlternate = requireLayerAlternate;
        this.minOuterWallDistance = minOuterWallDistance;
        this.maxOuterWallDistance = maxOuterWallDistance;
        this.minDistributionPoints = minDistributionPoints;
        this.maxDistributionPoints = maxDistributionPoints;
        this.minPointOffset = minPointsOffset;
        this.maxPointOffset = maxPointsOffset;
        this.minGenOffset = minGenOffset;
        this.maxGenOffset = maxGenOffset;
        this.noiseMultiplier = noiseMultiplier;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("blocks"), this.geodeBlockSettings.serialize(ops).getValue());
        builder.put(ops.createString("layers"), this.geodeLayerSettings.serialize(ops).getValue());
        builder.put(ops.createString("crack"), this.geodeCrackSettings.serialize(ops).getValue());
        builder.put(ops.createString("use_potential_placements_chance"), ops.createDouble(this.usePotentialPlacementsChance));
        builder.put(ops.createString("use_alternate_layer0_chance"), ops.createDouble(this.useAlternateLayerChance));
        builder.put(ops.createString("placements_require_layer0_alternate"), ops.createBoolean(this.placementsRequireLayerAlternate));
        builder.put(ops.createString("min_outer_wall_distance"), ops.createInt(this.minOuterWallDistance));
        builder.put(ops.createString("max_outer_wall_distance"), ops.createInt(this.maxOuterWallDistance));
        builder.put(ops.createString("min_distribution_points"), ops.createInt(this.minDistributionPoints));
        builder.put(ops.createString("max_distribution_points"), ops.createInt(this.maxDistributionPoints));
        builder.put(ops.createString("min_point_offset"), ops.createInt(this.minPointOffset));
        builder.put(ops.createString("max_point_offset"), ops.createInt(this.maxPointOffset));
        builder.put(ops.createString("min_gen_offset"), ops.createInt(this.minGenOffset));
        builder.put(ops.createString("max_gen_offset"), ops.createInt(this.maxGenOffset));
        builder.put(ops.createString("noise_multiplier"), ops.createDouble(this.noiseMultiplier));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    public static <T> GeodeFeatureConfig deserialize(Dynamic<T> ops) {
        GeodeBlockSettings blockSettings = GeodeBlockSettings.deserialize(ops);
        GeodeLayerSettings layerSettings = GeodeLayerSettings.deserialize(ops);
        GeodeCrackSettings crackSettings = GeodeCrackSettings.deserialize(ops);
        double usePotentialPlacementsChance = ops.get("use_potential_placements_chance").asDouble(0.35);
        double usePotentialAlternateLayer0Chance = ops.get("use_alternate_layer0_chance").asDouble(0.0);
        boolean placementsRequireLayer0Alternate = ops.get("placements_require_layer0_alternate").asBoolean(true);
        int minOuterWallsDistance = ops.get("min_outer_wall_distance").asInt(4);
        int maxOuterWallsDistance = ops.get("max_outer_wall_distance").asInt(6);
        int minDistributionPoints = ops.get("min_distribution_points").asInt(3);
        int maxDistributionPoints = ops.get("max_distribution_points").asInt(5);
        int minPointOffset = ops.get("min_point_offset").asInt(1);
        int maxPointOffset = ops.get("max_point_offset").asInt(3);
        int minGenOffset = ops.get("min_gen_offset").asInt(-16);
        int maxGenOffset = ops.get("max_gen_offset").asInt(16);
        double noiseMultiplier = ops.get("noise_multiplier").asDouble(0.05);
        return new GeodeFeatureConfig(blockSettings, layerSettings, crackSettings, usePotentialPlacementsChance, usePotentialAlternateLayer0Chance, placementsRequireLayer0Alternate, minOuterWallsDistance, maxOuterWallsDistance, minDistributionPoints, maxDistributionPoints, minPointOffset, maxPointOffset, minGenOffset, maxGenOffset, noiseMultiplier);
    }
}

