/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class GlowLichenConfig
implements IFeatureConfig {
    public final int searchRange;
    public final boolean canPlaceOnFloor;
    public final boolean canPlaceOnCeiling;
    public final boolean canPlaceOnWall;
    public final float chanceOfSpreading;
    public final List<BlockState> canBePlacedOn;
    public final List<Direction> validDirections;

    public GlowLichenConfig(int searchRange, boolean canPlaceOnFloor, boolean canPlaceOnCeiling, boolean canPlaceOnWall, float chanceOfSpreading, List<BlockState> canBePlacedOn) {
        this.searchRange = searchRange;
        this.canPlaceOnFloor = canPlaceOnFloor;
        this.canPlaceOnCeiling = canPlaceOnCeiling;
        this.canPlaceOnWall = canPlaceOnWall;
        this.chanceOfSpreading = chanceOfSpreading;
        this.canBePlacedOn = canBePlacedOn;
        ArrayList directions = Lists.newArrayList();
        if (canPlaceOnCeiling) {
            directions.add(Direction.UP);
        }
        if (canPlaceOnFloor) {
            directions.add(Direction.DOWN);
        }
        if (canPlaceOnWall) {
            Direction.Plane.HORIZONTAL.forEach(directions::add);
        }
        this.validDirections = Collections.unmodifiableList(directions);
    }

    public boolean canBePlacedOn(Block block) {
        return this.canBePlacedOn.stream().anyMatch(blockx -> blockx.func_177230_c().equals(block));
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("search_range"), ops.createInt(this.searchRange));
        builder.put(ops.createString("can_place_on_floor"), ops.createBoolean(this.canPlaceOnFloor));
        builder.put(ops.createString("can_place_on_ceiling"), ops.createBoolean(this.canPlaceOnCeiling));
        builder.put(ops.createString("can_place_on_wall"), ops.createBoolean(this.canPlaceOnWall));
        builder.put(ops.createString("chance_of_spreading"), ops.createFloat(this.chanceOfSpreading));
        builder.put(ops.createString("can_be_placed_on"), ops.createList(this.canBePlacedOn.stream().map(state -> BlockState.func_215689_a((DynamicOps)ops, (BlockState)state).getValue())));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    public static <T> GlowLichenConfig deserialize(Dynamic<T> ops) {
        int searchRange = ops.get("search_range").asInt(10);
        boolean canPlaceOnFloor = ops.get("can_place_on_floor").asBoolean(false);
        boolean canPlaceOnCeiling = ops.get("can_place_on_ceiling").asBoolean(false);
        boolean canPlaceOnWall = ops.get("can_place_on_wall").asBoolean(false);
        float chanceOfSpreading = ops.get("chance_of_spreading").asFloat(0.5f);
        List canBePlacedOn = ops.get("can_be_placed_on").asList(BlockState::func_215698_a);
        return new GlowLichenConfig(searchRange, canPlaceOnFloor, canPlaceOnCeiling, canPlaceOnWall, chanceOfSpreading, canBePlacedOn);
    }
}

