/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.util.math.UniformFloat;
import com.blackgear.cavesandcliffs.common.util.math.UniformInt;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class LargeDripstoneConfig
implements IFeatureConfig {
    public final int floorToCeilingSearchRange;
    public final UniformInt columnRadius;
    public final UniformFloat heightScale;
    public final float maxColumnRadiusToCaveHeightRatio;
    public final UniformFloat stalactiteBluntness;
    public final UniformFloat stalagmiteBluntness;
    public final UniformFloat windSpeed;
    public final int minRadiusForWind;
    public final float minBluntnessForWind;

    public LargeDripstoneConfig(int floorToCeilingSearchRange, UniformInt columnRadius, UniformFloat heightScale, float maxColumnRadiusToCaveHeightRatio, UniformFloat stalactiteBluntness, UniformFloat stalagmiteBluntness, UniformFloat windSpeed, int minRadiusForWind, float minBluntnessForWind) {
        this.floorToCeilingSearchRange = floorToCeilingSearchRange;
        this.columnRadius = columnRadius;
        this.heightScale = heightScale;
        this.maxColumnRadiusToCaveHeightRatio = maxColumnRadiusToCaveHeightRatio;
        this.stalactiteBluntness = stalactiteBluntness;
        this.stalagmiteBluntness = stalagmiteBluntness;
        this.windSpeed = windSpeed;
        this.minRadiusForWind = minRadiusForWind;
        this.minBluntnessForWind = minBluntnessForWind;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("floor_to_ceiling_search_range"), ops.createInt(this.floorToCeilingSearchRange));
        builder.put(ops.createString("column_radius"), this.columnRadius.func_218175_a(ops));
        builder.put(ops.createString("height_scale"), this.heightScale.func_218175_a(ops));
        builder.put(ops.createString("max_column_radius_to_cave_height_ratio"), ops.createFloat(this.maxColumnRadiusToCaveHeightRatio));
        builder.put(ops.createString("stalactite_bluntness"), this.stalactiteBluntness.func_218175_a(ops));
        builder.put(ops.createString("stalagmite_bluntness"), this.stalagmiteBluntness.func_218175_a(ops));
        builder.put(ops.createString("wind_speed"), this.windSpeed.func_218175_a(ops));
        builder.put(ops.createString("min_radius_for_wind"), ops.createInt(this.minRadiusForWind));
        builder.put(ops.createString("min_bluntness_for_wind"), ops.createFloat(this.minBluntnessForWind));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    public static <T> LargeDripstoneConfig deserialize(Dynamic<T> ops) {
        int floorToCeilingSearchRange = ops.get("floor_to_ceiling_search_range").asInt(30);
        UniformInt columnRadius = UniformInt.deserialize(ops.get("column_radius").orElseEmptyList());
        UniformFloat heightScale = UniformFloat.deserialize(ops.get("height_scale").orElseEmptyList());
        float maxColumnRadiusToCaveHeightRatio = ops.get("max_column_radius_to_cave_height_ratio").asFloat(0.0f);
        UniformFloat stalactiteBluntness = UniformFloat.deserialize(ops.get("stalactite_bluntness").orElseEmptyList());
        UniformFloat stalagmiteBluntness = UniformFloat.deserialize(ops.get("stalagmite_bluntness").orElseEmptyList());
        UniformFloat windSpeed = UniformFloat.deserialize(ops.get("wind_speed").orElseEmptyList());
        int minRadiusForWind = ops.get("min_radius_for_wind").asInt(0);
        float minBluntnessForWind = ops.get("min_bluntness_for_wind").asFloat(0.0f);
        return new LargeDripstoneConfig(floorToCeilingSearchRange, columnRadius, heightScale, maxColumnRadiusToCaveHeightRatio, stalactiteBluntness, stalagmiteBluntness, windSpeed, minRadiusForWind, minBluntnessForWind);
    }
}

