/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.tags.CCBBlockTags;
import com.blackgear.cavesandcliffs.common.util.math.CCBMathHelper;
import com.blackgear.cavesandcliffs.common.util.math.UniformFloat;
import com.blackgear.cavesandcliffs.common.world.gen.Column;
import com.blackgear.cavesandcliffs.common.world.gen.feature.DripstoneUtils;
import com.blackgear.cavesandcliffs.common.world.gen.feature.LargeDripstoneConfig;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;

public class LargeDripstoneFeature
extends Feature<LargeDripstoneConfig> {
    public LargeDripstoneFeature(Function<Dynamic<?>, ? extends LargeDripstoneConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, LargeDripstoneConfig config) {
        if (!DripstoneUtils.isEmptyOrWater(worldIn, pos)) {
            return false;
        }
        Optional<Column> optionalColumn = Column.scan((IWorldGenerationReader)worldIn, pos, config.floorToCeilingSearchRange, DripstoneUtils::isEmptyOrWater, DripstoneUtils::isDripstoneBase);
        if (optionalColumn.isPresent() && optionalColumn.get() instanceof Column.Range) {
            Column.Range range = (Column.Range)optionalColumn.get();
            if (range.height() < 4) {
                return false;
            }
            int height = (int)((float)range.height() * config.maxColumnRadiusToCaveHeightRatio);
            int distance = MathHelper.func_76125_a((int)height, (int)config.columnRadius.getBaseValue(), (int)config.columnRadius.getMaxValue());
            int base = CCBMathHelper.randomBetweenInclusive(rand, config.columnRadius.getBaseValue(), distance);
            LargeDripstone ceiling = LargeDripstoneFeature.makeDripstone(new BlockPos(pos.func_177958_n(), range.ceiling() - 1, pos.func_177952_p()), false, rand, base, config.stalactiteBluntness, config.heightScale);
            LargeDripstone floor = LargeDripstoneFeature.makeDripstone(new BlockPos(pos.func_177958_n(), range.floor() - 1, pos.func_177952_p()), true, rand, base, config.stalactiteBluntness, config.heightScale);
            WindOffsetter windOffsetter = ceiling.isSuitableForWind(config) && floor.isSuitableForWind(config) ? new WindOffsetter(pos.func_177956_o(), rand, config.windSpeed) : WindOffsetter.noWind();
            boolean ceilingOffset = ceiling.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldIn, windOffsetter);
            boolean floorOffset = floor.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldIn, windOffsetter);
            if (ceilingOffset && ceiling.getMinY() > 0) {
                ceiling.placeBlocks(worldIn, rand, windOffsetter);
            }
            if (floorOffset && floor.getMaxY() < 55) {
                floor.placeBlocks(worldIn, rand, windOffsetter);
            }
            return true;
        }
        return false;
    }

    private static LargeDripstone makeDripstone(BlockPos pos, boolean pointingUp, Random rand, int radius, UniformFloat bluntness, UniformFloat scale) {
        return new LargeDripstone(pos, pointingUp, radius, bluntness.sample(rand), scale.sample(rand));
    }

    static final class LargeDripstone {
        private BlockPos root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        private LargeDripstone(BlockPos root, boolean pointingUp, int radius, double bluntness, double scale) {
            this.root = root;
            this.pointingUp = pointingUp;
            this.radius = radius;
            this.bluntness = bluntness;
            this.scale = scale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        private int getMinY() {
            return this.pointingUp ? this.root.func_177956_o() : this.root.func_177956_o() - this.getHeight();
        }

        private int getMaxY() {
            return !this.pointingUp ? this.root.func_177956_o() : this.root.func_177956_o() + this.getHeight();
        }

        private boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(IWorld worldIn, WindOffsetter windOffsetter) {
            while (this.radius > 1) {
                BlockPos.Mutable mutablePos = new BlockPos.Mutable(this.root);
                int height = Math.min(10, this.getHeight());
                for (int i = 0; i < height; ++i) {
                    if (worldIn.func_180495_p((BlockPos)mutablePos).func_177230_c().equals(Blocks.field_150353_l)) {
                        return false;
                    }
                    if (DripstoneUtils.isCircleMostlyEmbeddedInStone(worldIn, windOffsetter.offset((BlockPos)mutablePos), this.radius)) {
                        this.root = mutablePos;
                        return true;
                    }
                    mutablePos.func_189536_c(this.pointingUp ? Direction.DOWN : Direction.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float radius) {
            return (int)DripstoneUtils.getDripstoneHeight(radius, this.radius, this.scale, this.bluntness);
        }

        private void placeBlocks(IWorld worldIn, Random rand, WindOffsetter offsetter) {
            for (int x = -this.radius; x <= this.radius; ++x) {
                block1: for (int z = -this.radius; z <= this.radius; ++z) {
                    int height;
                    float radius = MathHelper.func_76129_c((float)(x * x + z * z));
                    if (!(radius <= (float)this.radius) || (height = this.getHeightAtRadius(radius)) <= 0) continue;
                    if ((double)rand.nextFloat() < 0.2) {
                        height = (int)((float)height * CCBMathHelper.randomBetween(rand, 0.8f, 1.0f));
                    }
                    BlockPos.Mutable mutablePos = new BlockPos.Mutable(this.root.func_177982_a(x, 0, z));
                    boolean shouldPlace = false;
                    for (int i = 0; i < height; ++i) {
                        BlockPos pos = offsetter.offset((BlockPos)mutablePos);
                        if (DripstoneUtils.isEmptyOrWaterOrLava(worldIn, pos)) {
                            shouldPlace = true;
                            Block dripstone = (Block)CCBBlocks.DRIPSTONE_BLOCK.get();
                            worldIn.func_180501_a(pos, dripstone.func_176223_P(), 2);
                        } else if (shouldPlace && worldIn.func_180495_p(pos).func_203425_a(CCBBlockTags.BASE_STONE_OVERWORLD)) continue block1;
                        mutablePos.func_189536_c(this.pointingUp ? Direction.UP : Direction.DOWN);
                    }
                }
            }
        }

        private boolean isSuitableForWind(LargeDripstoneConfig config) {
            return this.radius >= config.minRadiusForWind && this.bluntness >= (double)config.minBluntnessForWind;
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final Vec3d windSpeed;

        private WindOffsetter(int originY, Random rand, UniformFloat speed) {
            this.originY = originY;
            this.windSpeed = new Vec3d((double)speed.sample(rand), 0.0, (double)speed.sample(rand));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        private static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        private BlockPos offset(BlockPos pos) {
            if (this.windSpeed == null) {
                return pos;
            }
            int y = this.originY - pos.func_177956_o();
            Vec3d windSpeedScale = this.windSpeed.func_186678_a((double)y);
            return pos.func_177963_a(windSpeedScale.field_72450_a, 0.0, windSpeedScale.field_72449_c);
        }
    }
}

