/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class LushVineFeature
extends Feature<NoFeatureConfig> {
    public LushVineFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!worldIn.func_175623_d(pos)) {
            return false;
        }
        this.generateVinesInArea(worldIn, rand, pos, Direction.Plane.HORIZONTAL.func_179518_a(rand));
        this.generateVines(worldIn, pos);
        return true;
    }

    private void generateVinesInArea(IWorld world, Random rand, BlockPos pos, Direction direction) {
        int height = rand.nextInt(4) + 2;
        if (!LushVineFeature.canGenerateVine(world.func_180495_p(pos.func_177972_a(direction))) || !world.func_180495_p(pos).func_196958_f()) {
            return;
        }
        world.func_180501_a(pos, (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.func_176267_a((Direction)direction), (Comparable)Boolean.valueOf(true)), 3);
        BlockPos.Mutable mutable = new BlockPos.Mutable(pos);
        for (int i = 0; i < height; ++i) {
            mutable.func_189536_c(Direction.DOWN);
            if (!world.func_180495_p((BlockPos)mutable).func_196958_f()) {
                return;
            }
            world.func_180501_a((BlockPos)mutable, (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.func_176267_a((Direction)direction), (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void generateVines(IWorld world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos offset = pos.func_177972_a(direction);
            BlockPos up = offset.func_177984_a();
            if (!this.isCeiling(world, up, world.func_180495_p(up)) || !(world.func_201674_k().nextDouble() < 0.125)) continue;
            BlockState state = world.func_180495_p(offset);
            boolean did = false;
            while (state.func_177230_c().isAir(state, (IBlockReader)world, offset) && offset.func_177956_o() > 0) {
                world.func_180501_a(offset, (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.func_176267_a((Direction)direction.func_176734_d()), (Comparable)Boolean.valueOf(true)), 2);
                offset = offset.func_177977_b();
                state = world.func_180495_p(offset);
                did = true;
            }
            if (!did) continue;
            return;
        }
    }

    private boolean isCeiling(IWorld world, BlockPos pos, BlockState state) {
        if (!state.func_200015_d((IBlockReader)world, pos)) {
            return false;
        }
        BlockPos downPos = pos.func_177977_b();
        return world.func_175623_d(downPos) || world.func_180495_p(downPos).func_185904_a().func_76222_j();
    }

    private static boolean canGenerateVine(BlockState state) {
        return state.func_200132_m();
    }
}

