/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.util.math.BlockPosHelper;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class RootsAndBlossomFeature
extends Feature<NoFeatureConfig> {
    public RootsAndBlossomFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!worldIn.func_175623_d(pos)) {
            return false;
        }
        this.generateBlossom(worldIn, rand, pos);
        this.generateRoots(worldIn, rand, pos);
        return true;
    }

    private void generateRoots(IWorld worldIn, Random rand, BlockPos pos) {
        BlockPos.Mutable validPos = new BlockPos.Mutable();
        for (int i = 0; i < 50; ++i) {
            BlockState baseState;
            BlockPosHelper.setAndOffset(validPos, (Vec3i)pos, rand.nextInt(8) - rand.nextInt(8), rand.nextInt(2) - rand.nextInt(7), rand.nextInt(8) - rand.nextInt(8));
            if (!worldIn.func_175623_d((BlockPos)validPos) || !(baseState = worldIn.func_180495_p(validPos.func_177984_a())).func_177230_c().equals(CCBBlocks.ROOTED_DIRT.get()) && !baseState.func_177230_c().equals(Blocks.field_150346_d)) continue;
            this.placeHangingRoots(worldIn, (BlockPos)validPos);
        }
    }

    private void placeHangingRoots(IWorld worldIn, BlockPos pos) {
        if (worldIn.func_175623_d(pos)) {
            worldIn.func_180501_a(pos, ((Block)CCBBlocks.HANGING_ROOTS.get()).func_176223_P(), 2);
        }
    }

    private void generateBlossom(IWorld worldIn, Random rand, BlockPos pos) {
        BlockPos.Mutable validPos = new BlockPos.Mutable();
        for (int i = 0; i < 50; ++i) {
            BlockState baseState;
            BlockPosHelper.setAndOffset(validPos, (Vec3i)pos, rand.nextInt(8) - rand.nextInt(8), rand.nextInt(2) - rand.nextInt(7), rand.nextInt(8) - rand.nextInt(8));
            if (!worldIn.func_175623_d((BlockPos)validPos) || !(baseState = worldIn.func_180495_p(validPos.func_177984_a())).func_177230_c().equals(CCBBlocks.MOSS_BLOCK.get())) continue;
            this.placeSporeBlossom(worldIn, (BlockPos)validPos);
        }
    }

    private void placeSporeBlossom(IWorld worldIn, BlockPos pos) {
        if (worldIn.func_175623_d(pos)) {
            worldIn.func_180501_a(pos, ((Block)CCBBlocks.SPORE_BLOSSOM.get()).func_176223_P(), 2);
        }
    }
}

