/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class SmallDripstoneConfig
implements IFeatureConfig {
    public final int maxPlacements;
    public final int emptySpaceSearchRadius;
    public final int maxOffsetFromOrigin;
    public final float chanceOfTallerDripstone;

    public SmallDripstoneConfig(int maxPlacements, int emptySpaceSearchRadius, int maxOffsetFromOrigin, float chanceOfTallerDripstone) {
        this.maxPlacements = maxPlacements;
        this.emptySpaceSearchRadius = emptySpaceSearchRadius;
        this.maxOffsetFromOrigin = maxOffsetFromOrigin;
        this.chanceOfTallerDripstone = chanceOfTallerDripstone;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("max_placements"), ops.createInt(this.maxPlacements));
        builder.put(ops.createString("empty_space_search_radius"), ops.createInt(this.emptySpaceSearchRadius));
        builder.put(ops.createString("max_offset_from_origin"), ops.createInt(this.maxOffsetFromOrigin));
        builder.put(ops.createString("chance_of_taller_dripstone"), ops.createFloat(this.chanceOfTallerDripstone));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    public static <T> SmallDripstoneConfig deserialize(Dynamic<T> ops) {
        int maxPlacements = ops.get("max_placements").asInt(5);
        int emptySpaceSearchRadius = ops.get("empty_space_search_radius").asInt(10);
        int maxOffsetFromOrigin = ops.get("max_offset_from_origin").asInt(2);
        float chanceOfTallerDripstone = ops.get("chance_of_taller_dripstone").asFloat(0.2f);
        return new SmallDripstoneConfig(maxPlacements, emptySpaceSearchRadius, maxOffsetFromOrigin, chanceOfTallerDripstone);
    }
}

