/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.util.math.CCBMathHelper;
import com.blackgear.cavesandcliffs.common.world.gen.feature.DripstoneUtils;
import com.blackgear.cavesandcliffs.common.world.gen.feature.SmallDripstoneConfig;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;

public class SmallDripstoneFeature
extends Feature<SmallDripstoneConfig> {
    public SmallDripstoneFeature(Function<Dynamic<?>, ? extends SmallDripstoneConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, SmallDripstoneConfig config) {
        if (!DripstoneUtils.isEmptyOrWater(worldIn, pos)) {
            return false;
        }
        int maxPlacements = CCBMathHelper.randomBetweenInclusive(rand, 1, config.maxPlacements);
        boolean shouldPlace = false;
        for (int count = 0; count < maxPlacements; ++count) {
            BlockPos blockPos = SmallDripstoneFeature.randomOffset(rand, pos, config);
            if (!this.searchAndTryPlaceDripstone(worldIn, rand, blockPos, config)) continue;
            shouldPlace = true;
        }
        return shouldPlace;
    }

    private boolean searchAndTryPlaceDripstone(IWorld worldIn, Random rand, BlockPos pos, SmallDripstoneConfig config) {
        Direction randomDirection = Direction.func_176741_a((Random)rand);
        Direction verticalDirection = rand.nextBoolean() ? Direction.UP : Direction.DOWN;
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(pos);
        for (int count = 0; count < config.emptySpaceSearchRadius; ++count) {
            if (!DripstoneUtils.isEmptyOrWater(worldIn, (BlockPos)mutablePos)) {
                return false;
            }
            if (this.tryToPlaceDripstone(worldIn, rand, (BlockPos)mutablePos, verticalDirection, config)) {
                return true;
            }
            if (this.tryToPlaceDripstone(worldIn, rand, (BlockPos)mutablePos, verticalDirection.func_176734_d(), config)) {
                return true;
            }
            mutablePos.func_189536_c(randomDirection);
        }
        return false;
    }

    private boolean tryToPlaceDripstone(IWorld worldIn, Random rand, BlockPos pos, Direction direction, SmallDripstoneConfig config) {
        if (!DripstoneUtils.isEmptyOrWater(worldIn, pos)) {
            return false;
        }
        BlockPos blockPos = pos.func_177972_a(direction.func_176734_d());
        BlockState state = worldIn.func_180495_p(blockPos);
        if (!DripstoneUtils.isDripstoneBase(state)) {
            return false;
        }
        SmallDripstoneFeature.createPatchOfDripstoneBlocks(worldIn, rand, blockPos);
        int tallerDripstoneChance = rand.nextFloat() < config.chanceOfTallerDripstone && DripstoneUtils.isEmptyOrWater(worldIn, pos.func_177972_a(direction)) ? 2 : 1;
        DripstoneUtils.growPointedDripstone(worldIn, pos, direction, tallerDripstoneChance, false);
        return true;
    }

    private static void createPatchOfDripstoneBlocks(IWorld worldIn, Random rand, BlockPos pos) {
        DripstoneUtils.placeDripstoneBlockIfPossible(worldIn, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!(rand.nextFloat() >= 0.3f)) continue;
            BlockPos offset = pos.func_177972_a(direction);
            DripstoneUtils.placeDripstoneBlockIfPossible(worldIn, offset);
            if (rand.nextBoolean()) continue;
            BlockPos randomOffset = offset.func_177972_a(Direction.func_176741_a((Random)rand));
            DripstoneUtils.placeDripstoneBlockIfPossible(worldIn, randomOffset);
            if (rand.nextBoolean()) continue;
            BlockPos blockPos = randomOffset.func_177972_a(Direction.func_176741_a((Random)rand));
            DripstoneUtils.placeDripstoneBlockIfPossible(worldIn, blockPos);
        }
    }

    private static BlockPos randomOffset(Random rand, BlockPos pos, SmallDripstoneConfig config) {
        return pos.func_177982_a(CCBMathHelper.randomBetweenInclusive(rand, -config.maxOffsetFromOrigin, config.maxOffsetFromOrigin), CCBMathHelper.randomBetweenInclusive(rand, -config.maxOffsetFromOrigin, config.maxOffsetFromOrigin), CCBMathHelper.randomBetweenInclusive(rand, -config.maxOffsetFromOrigin, config.maxOffsetFromOrigin));
    }
}

