/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.util.math.UniformFloat;
import com.blackgear.cavesandcliffs.common.util.math.UniformInt;
import com.blackgear.cavesandcliffs.common.world.biome.AbstractCaveBiome;
import com.blackgear.cavesandcliffs.common.world.gen.GeodeBlockSettings;
import com.blackgear.cavesandcliffs.common.world.gen.GeodeCrackSettings;
import com.blackgear.cavesandcliffs.common.world.gen.GeodeLayerSettings;
import com.blackgear.cavesandcliffs.common.world.gen.feature.DripstoneClusterConfig;
import com.blackgear.cavesandcliffs.common.world.gen.feature.GeodeFeatureConfig;
import com.blackgear.cavesandcliffs.common.world.gen.feature.GlowLichenConfig;
import com.blackgear.cavesandcliffs.common.world.gen.feature.LargeDripstoneConfig;
import com.blackgear.cavesandcliffs.common.world.gen.feature.SmallDripstoneConfig;
import com.blackgear.cavesandcliffs.core.CCBConfig;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.CCBCarvers;
import com.blackgear.cavesandcliffs.core.registries.CCBEntityType;
import com.blackgear.cavesandcliffs.core.registries.CCBFeatures;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateProvidingFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.placement.ChanceRangeConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class VanillaBiomeFeatures {
    public static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    public static final BlockState AMETHYST_BLOCK = ((Block)CCBBlocks.AMETHYST_BLOCK.get()).func_176223_P();
    public static final BlockState BUDDING_AMETHYST = ((Block)CCBBlocks.BUDDING_AMETHYST.get()).func_176223_P();
    public static final BlockState SMALL_AMETHYST_BUD = ((Block)CCBBlocks.SMALL_AMETHYST_BUD.get()).func_176223_P();
    public static final BlockState MEDIUM_AMETHYST_BUD = ((Block)CCBBlocks.MEDIUM_AMETHYST_BUD.get()).func_176223_P();
    public static final BlockState LARGE_AMETHYST_BUD = ((Block)CCBBlocks.LARGE_AMETHYST_BUD.get()).func_176223_P();
    public static final BlockState AMETHYST_CLUSTER = ((Block)CCBBlocks.AMETHYST_CLUSTER.get()).func_176223_P();
    public static final BlockState CALCITE = ((Block)CCBBlocks.CALCITE.get()).func_176223_P();
    public static final BlockState TUFF = ((Block)CCBBlocks.TUFF.get()).func_176223_P();
    public static final BlockState COPPER_ORE = ((Block)CCBBlocks.COPPER_ORE.get()).func_176223_P();
    public static final BlockState AZALEA = ((Block)CCBBlocks.AZALEA.get()).func_176223_P();
    public static final BlockState FLOWERING_AZALEA = ((Block)CCBBlocks.FLOWERING_AZALEA.get()).func_176223_P();
    public static final BlockState MOSS_CARPET = ((Block)CCBBlocks.MOSS_CARPET.get()).func_176223_P();
    public static final BlockState SMALL_DRIPLEAF = ((Block)CCBBlocks.SMALL_DRIPLEAF.get()).func_176223_P();
    public static final BlockState GRASS = Blocks.field_150349_c.func_176223_P();
    public static final BlockState TALL_GRASS = Blocks.field_196804_gh.func_176223_P();
    public static final BlockClusterFeatureConfig SMALL_DRIPLEAF_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SMALL_DRIPLEAF), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static final BlockStateProvidingFeatureConfig LUSH_CAVE_CONFIG = new BlockStateProvidingFeatureConfig((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(FLOWERING_AZALEA, 5).func_227407_a_(AZALEA, 15).func_227407_a_(GRASS, 90));
    public static final BlockClusterFeatureConfig MOSS_CARPET_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)CCBBlocks.MOSS_CARPET.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_150348_b, (Object)Blocks.field_196656_g, (Object)Blocks.field_196654_e, (Object)Blocks.field_196650_c, (Object)Blocks.field_150351_n, (Object)Blocks.field_150435_aG, (Object[])new Block[]{(Block)CCBBlocks.MOSS_BLOCK.get()})).func_227317_b_().func_227322_d_();
    private static final Random rand = new Random();

    public static void addGlobalFeatures() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (biome.func_201856_r() == Biome.Category.NETHER || biome.func_201856_r() == Biome.Category.THEEND || biome instanceof AbstractCaveBiome) continue;
            if (((Boolean)CCBConfig.useCopperGeneration.get()).booleanValue()) {
                VanillaBiomeFeatures.addCopperOre(biome);
            }
            VanillaBiomeFeatures.addDefaultCrystalFormations(biome);
            VanillaBiomeFeatures.addDefaultUndergroundVariety(biome);
            biome.func_201866_a(EntityClassification.WATER_CREATURE, new Biome.SpawnListEntry((EntityType)CCBEntityType.GLOW_SQUID.get(), 4, 1, 4));
        }
    }

    public static void addCarvers(Biome biomeIn) {
        biomeIn.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)((WorldCarver)CCBCarvers.ROOM_CARVER.get()), (ICarverConfig)new ProbabilityConfig(0.2f)));
    }

    public static void addCopperOre(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, COPPER_ORE, 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 0, 0, 64))));
    }

    public static void addDefaultCrystalFormations(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, ((Feature)CCBFeatures.GEODE.get()).func_225566_b_((IFeatureConfig)new GeodeFeatureConfig(new GeodeBlockSettings((BlockStateProvider)new SimpleBlockStateProvider(AIR), (BlockStateProvider)new SimpleBlockStateProvider(AMETHYST_BLOCK), (BlockStateProvider)new SimpleBlockStateProvider(BUDDING_AMETHYST), (BlockStateProvider)new SimpleBlockStateProvider(CALCITE), (BlockStateProvider)new SimpleBlockStateProvider(TUFF), (List<BlockState>)ImmutableList.of((Object)SMALL_AMETHYST_BUD, (Object)MEDIUM_AMETHYST_BUD, (Object)LARGE_AMETHYST_BUD, (Object)AMETHYST_CLUSTER)), new GeodeLayerSettings(1.7, 2.2, 3.2, 4.2), new GeodeCrackSettings(0.95, 2.0, 2), 0.35, 0.083, true, 4, 7, 3, 5, 1, 3, -16, 16, 0.05)).func_227228_a_(Placement.field_215032_r.func_227446_a_((IPlacementConfig)new ChanceRangeConfig(0.020833334f, 6, 0, 47))));
    }

    public static void addDripstone(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, ((Feature)CCBFeatures.DRIPSTONE_CLUSTER_FEATURE.get()).func_225566_b_((IFeatureConfig)new DripstoneClusterConfig(12, UniformInt.of(3, 3), UniformInt.of(2, 6), 1, 3, UniformInt.of(2, 2), UniformFloat.of(0.3f, 0.4f), UniformFloat.of(0.1f, 0.9f), 0.1f, 0.3f, 0.1f, 3, 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(UniformInt.of(5, 10).sample(rand), 0, 0, 60))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ((Feature)CCBFeatures.LARGE_DRIPSTONE_FEATURE.get()).func_225566_b_((IFeatureConfig)new LargeDripstoneConfig(30, UniformInt.of(3, 6), UniformFloat.of(0.4f, 1.6f), 0.33f, UniformFloat.of(0.3f, 0.6f), UniformFloat.of(0.4f, 0.6f), UniformFloat.of(0.0f, 0.2f), 5, 0.7f)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(UniformInt.of(1, 4).sample(rand), 0, 0, 60))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ((Feature)CCBFeatures.SMALL_DRIPSTONE_FEATURE.get()).func_225566_b_((IFeatureConfig)new SmallDripstoneConfig(5, 10, 2, 0.2f)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(UniformInt.of(20, 40).sample(rand), 0, 0, 60))));
    }

    public static void addDefaultUndergroundVariety(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)CCBFeatures.GLOW_LICHEN_FEATURE.get()).func_225566_b_((IFeatureConfig)new GlowLichenConfig(10, false, true, true, 0.5f, (List<BlockState>)ImmutableList.of((Object)Blocks.field_150348_b.func_176223_P(), (Object)Blocks.field_196656_g.func_176223_P(), (Object)Blocks.field_196654_e.func_176223_P(), (Object)Blocks.field_196650_c.func_176223_P(), (Object)((Block)CCBBlocks.DRIPSTONE_BLOCK.get()).func_176223_P(), (Object)((Block)CCBBlocks.CALCITE.get()).func_176223_P(), (Object)((Block)CCBBlocks.TUFF.get()).func_176223_P()))).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(UniformInt.of(5, 5).sample(rand), 0, 0, 55))));
    }
}

