/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries;

import com.blackgear.cavesandcliffs.common.world.biome.AbstractCaveBiome;
import com.blackgear.cavesandcliffs.common.world.biome.CaveBiome;
import com.blackgear.cavesandcliffs.common.world.biome.DeepDarkCaveBiome;
import com.blackgear.cavesandcliffs.common.world.biome.DripstoneCavesBiome;
import com.blackgear.cavesandcliffs.common.world.biome.LushCavesBiome;
import com.blackgear.cavesandcliffs.common.world.biome.provider.NoisePoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class CCBBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"cavesandcliffs");
    public static final RegistryObject<AbstractCaveBiome> CAVES = CCBBiomes.createBiome("caves", CaveBiome::new);
    public static final RegistryObject<AbstractCaveBiome> LUSH_CAVES = CCBBiomes.createBiome("lush_caves", LushCavesBiome::new);
    public static final RegistryObject<AbstractCaveBiome> DRIPSTONE_CAVES = CCBBiomes.createBiome("dripstone_caves", DripstoneCavesBiome::new);
    public static final RegistryObject<AbstractCaveBiome> DEEP_DARK_CAVES = CCBBiomes.createBiome("deep_dark_caves", DeepDarkCaveBiome::new);
    private static final HashMap<Biome, ArrayList<NoisePoint>> noisePoints = new HashMap();

    public static final void addBiomeNoise() {
        CCBBiomes.addNoisePoints((Biome)LUSH_CAVES.get(), new NoisePoint(0.0f, 0.5f, 0.0f, 0.0f, 1.0f));
        CCBBiomes.addNoisePoints((Biome)DRIPSTONE_CAVES.get(), new NoisePoint(0.0f, -0.5f, 0.0f, 0.0f, 1.0f));
        CCBBiomes.addNoisePoints((Biome)CAVES.get(), new NoisePoint(0.0f, 0.0f, 0.0f, -0.5f, 1.0f));
    }

    private static <B extends Biome> RegistryObject<B> createBiome(String name, Supplier<B> supplier) {
        return BIOMES.register(name, supplier);
    }

    public static void applyBiomeFeatures() {
        BIOMES.getEntries().forEach(builder -> {
            Biome biome = (Biome)builder.get();
            if (biome instanceof AbstractCaveBiome && biome != null) {
                ((AbstractCaveBiome)biome).addSpawnsAndFeatures();
            }
        });
    }

    public static List<NoisePoint> getNoisePoints(Biome biome) {
        ArrayList<NoisePoint> points = noisePoints.get(biome);
        return points != null ? points : Collections.emptyList();
    }

    private static Biome addNoisePoints(Biome biome, NoisePoint points) {
        ArrayList pointsList;
        HashMap<Biome, ArrayList<NoisePoint>> biomePoints = noisePoints;
        ArrayList hasBiome = (ArrayList)biomePoints.get(biome);
        if (hasBiome == null) {
            ArrayList nullPoints = new ArrayList();
            biomePoints.put(biome, nullPoints);
            pointsList = nullPoints;
        } else {
            pointsList = hasBiome;
        }
        Collections.addAll(pointsList, points);
        return biome;
    }
}

