/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries;

import com.blackgear.cavesandcliffs.common.util.BooleanSerializable;
import com.blackgear.cavesandcliffs.common.util.IntSerializable;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IDynamicSerializable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="cavesandcliffs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CCBMemoryModuleType {
    private static final List<MemoryModuleType<?>> MODULES = new ArrayList();
    public static final MemoryModuleType<PlayerEntity> NEAREST_VISIBLE_TARGETABLE_PLAYER = CCBMemoryModuleType.register("nearest_visible_targetable_player");
    public static final MemoryModuleType<Boolean> ATTACK_COOLING_DOWN = CCBMemoryModuleType.register("attack_cooling_down");
    public static final MemoryModuleType<LivingEntity> ATTACK_TARGET = CCBMemoryModuleType.register("attack_target");
    public static final MemoryModuleType<AgeableEntity> BREED_TARGET = CCBMemoryModuleType.register("breed_target");
    public static final MemoryModuleType<AgeableEntity> NEAREST_VISIBLE_ADULT = CCBMemoryModuleType.register("nearest_visible_adult");
    public static final MemoryModuleType<IntSerializable> PLAY_DEAD_TICKS = CCBMemoryModuleType.register("play_dead_ticks", Optional.of(IntSerializable::deserialize));
    public static final MemoryModuleType<PlayerEntity> TEMPTING_PLAYER = CCBMemoryModuleType.register("tempting_player");
    public static final MemoryModuleType<IntSerializable> TEMPTATION_COOLDOWN_TICKS = CCBMemoryModuleType.register("temptation_cooldown_ticks", Optional.of(IntSerializable::deserialize));
    public static final MemoryModuleType<BooleanSerializable> IS_TEMPTED = CCBMemoryModuleType.register("is_tempted", Optional.of(BooleanSerializable::deserialize));

    public static <U extends IDynamicSerializable> MemoryModuleType<U> register(String name, Optional<Function<Dynamic<?>, U>> function) {
        MemoryModuleType module = new MemoryModuleType(function);
        module.setRegistryName(name);
        MODULES.add(module);
        return module;
    }

    public static <U> MemoryModuleType<U> register(String name) {
        MemoryModuleType module = new MemoryModuleType(Optional.empty());
        module.setRegistryName(name);
        MODULES.add(module);
        return module;
    }

    @SubscribeEvent
    public static void registerTypes(RegistryEvent.Register<MemoryModuleType<?>> event) {
        MODULES.forEach(type -> event.getRegistry().register((IForgeRegistryEntry)type));
        MODULES.clear();
    }
}

