/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.client.world;

import com.blackgear.cavesandcliffs.common.world.biome.AbstractCaveBiome;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.block.BlockState;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientWorld.class})
public abstract class ClientWorldMixin
extends World {
    protected ClientWorldMixin(WorldInfo info, DimensionType dimType, BiFunction<World, Dimension, AbstractChunkProvider> provider, IProfiler profilerIn, boolean remote) {
        super(info, dimType, provider, profilerIn, remote);
    }

    @Inject(method={"animateTick(III)V"}, at={@At(value="RETURN")}, cancellable=true)
    private void tick(int posX, int posY, int posZ, CallbackInfo info) {
        Random random = new Random();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int i = 0; i < 667; ++i) {
            this.animate(posX, posY, posZ, 16, random, pos);
            this.animate(posX, posY, posZ, 32, random, pos);
        }
    }

    private void animate(int xCenter, int yCenter, int zCenter, int radius, Random rand, BlockPos.Mutable pos) {
        int x = xCenter + this.field_73012_v.nextInt(radius) - this.field_73012_v.nextInt(radius);
        int y = yCenter + this.field_73012_v.nextInt(radius) - this.field_73012_v.nextInt(radius);
        int z = zCenter + this.field_73012_v.nextInt(radius) - this.field_73012_v.nextInt(radius);
        pos.func_181079_c(x, y, z);
        BlockState blockstate = this.func_180495_p((BlockPos)pos);
        if (!blockstate.func_224756_o((IBlockReader)this, (BlockPos)pos) && this.func_226691_t_((BlockPos)pos) instanceof AbstractCaveBiome) {
            ((AbstractCaveBiome)this.func_226691_t_((BlockPos)pos)).getParticles().ifPresent(particles -> {
                if (particles.shouldAddParticles(rand)) {
                    this.func_195594_a(particles.getParticle(), (double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + rand.nextDouble(), (double)pos.func_177952_p() + rand.nextDouble(), 0.0, 0.0, 0.0);
                }
            });
        }
    }
}

