/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.client.world;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldRenderer.class})
public abstract class WorldRendererMixin {
    @Shadow
    @Final
    private Minecraft field_72777_q;
    @Shadow
    private int field_72773_u;
    @Shadow
    @Final
    private float[] field_228411_ak_;
    @Shadow
    @Final
    private float[] field_228412_al_;
    @Shadow
    @Final
    private static ResourceLocation field_228413_h_;
    @Shadow
    @Final
    private static ResourceLocation field_228414_i_;

    @Shadow
    public static int func_228421_a_(ILightReader lightReaderIn, BlockPos blockPosIn) {
        return WorldRendererMixin.func_228420_a_(lightReaderIn, lightReaderIn.func_180495_p(blockPosIn), blockPosIn);
    }

    @Shadow
    public static int func_228420_a_(ILightReader lightReaderIn, BlockState blockStateIn, BlockPos blockPosIn) {
        int lightValue;
        if (blockStateIn.func_227035_k_()) {
            return 0xF000F0;
        }
        int skyLight = lightReaderIn.func_226658_a_(LightType.SKY, blockPosIn);
        int blockLight = lightReaderIn.func_226658_a_(LightType.BLOCK, blockPosIn);
        if (blockLight < (lightValue = blockStateIn.getLightValue((IBlockReader)lightReaderIn, blockPosIn))) {
            blockLight = lightValue;
        }
        return skyLight << 20 | blockLight << 4;
    }

    @Inject(at={@At(value="HEAD")}, method={"renderRainSnow"})
    private void renderRainAndSnow(LightTexture lightMapIn, float partialTicks, double xIn, double yIn, double zIn, CallbackInfo info) {
        float rainStrength = this.field_72777_q.field_71441_e.func_72867_j(partialTicks);
        if (!(rainStrength <= 0.0f)) {
            lightMapIn.func_205109_c();
            ClientWorld world = this.field_72777_q.field_71441_e;
            int xFloor = MathHelper.func_76128_c((double)xIn);
            int yFloor = MathHelper.func_76128_c((double)yIn);
            int zFloor = MathHelper.func_76128_c((double)zIn);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            RenderSystem.enableAlphaTest();
            RenderSystem.disableCull();
            RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableDepthTest();
            int particleArea = 5;
            if (Minecraft.func_71375_t()) {
                particleArea = 10;
            }
            int chance = -1;
            float ticks = (float)this.field_72773_u + partialTicks;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.Mutable pos = new BlockPos.Mutable();
            for (int z = zFloor - particleArea; z <= zFloor + particleArea; ++z) {
                for (int x = xFloor - particleArea; x <= xFloor + particleArea; ++x) {
                    int chunkArea = (z - zFloor + 16) * 32 + x - xFloor + 16;
                    double rainSizeX = (double)this.field_228411_ak_[chunkArea] * 0.5;
                    double rainSizeZ = (double)this.field_228412_al_[chunkArea] * 0.5;
                    pos.func_181079_c(x, world.func_181545_F(), z);
                    Biome biome = world.func_226691_t_((BlockPos)pos);
                    if (biome.func_201851_b() == Biome.RainType.NONE) continue;
                    int worldHeight = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)pos).func_177956_o();
                    int minHeight = yFloor - particleArea;
                    int maxHeight = yFloor + particleArea;
                    if (minHeight < worldHeight) {
                        minHeight = worldHeight;
                    }
                    if (maxHeight < worldHeight) {
                        maxHeight = worldHeight;
                    }
                    int height = worldHeight;
                    if (worldHeight < yFloor) {
                        height = yFloor;
                    }
                    if (minHeight == maxHeight) continue;
                    Random random = new Random(x * x * 3121 + x * 45238971 ^ z * z * 418711 + z * 13761);
                    pos.func_181079_c(x, minHeight, z);
                    float temperature = biome.func_225486_c((BlockPos)pos);
                    if (temperature >= 0.15f) {
                        if (chance != 0) {
                            if (chance >= 0) {
                                tessellator.func_78381_a();
                            }
                            chance = 0;
                            this.field_72777_q.func_110434_K().func_110577_a(field_228413_h_);
                            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        int rainTicks = this.field_72773_u + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F;
                        float texV = -((float)rainTicks + partialTicks) / 32.0f * (3.0f + random.nextFloat());
                        double xArea = (double)((float)x + 0.5f) - xIn;
                        double zArea = (double)((float)z + 0.5f) - zIn;
                        float totalArea = MathHelper.func_76133_a((double)(xArea * xArea + zArea * zArea)) / (float)particleArea;
                        float alpha = ((1.0f - totalArea * totalArea) * 0.5f + 0.5f) * rainStrength;
                        pos.func_181079_c(x, height, z);
                        int combinedLight = WorldRendererMixin.func_228421_a_((ILightReader)world, (BlockPos)pos);
                        bufferBuilder.func_225582_a_((double)x - xIn - rainSizeX + 0.5, (double)maxHeight - yIn, (double)z - zIn - rainSizeZ + 0.5).func_225583_a_(0.0f, (float)minHeight * 0.25f + texV).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_227886_a_(combinedLight).func_181675_d();
                        bufferBuilder.func_225582_a_((double)x - xIn + rainSizeX + 0.5, (double)maxHeight - yIn, (double)z - zIn + rainSizeZ + 0.5).func_225583_a_(1.0f, (float)minHeight * 0.25f + texV).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_227886_a_(combinedLight).func_181675_d();
                        bufferBuilder.func_225582_a_((double)x - xIn + rainSizeX + 0.5, (double)minHeight - yIn, (double)z - zIn + rainSizeZ + 0.5).func_225583_a_(1.0f, (float)maxHeight * 0.25f + texV).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_227886_a_(combinedLight).func_181675_d();
                        bufferBuilder.func_225582_a_((double)x - xIn - rainSizeX + 0.5, (double)minHeight - yIn, (double)z - zIn - rainSizeZ + 0.5).func_225583_a_(0.0f, (float)maxHeight * 0.25f + texV).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_227886_a_(combinedLight).func_181675_d();
                        continue;
                    }
                    if (chance != 1) {
                        if (chance >= 0) {
                            tessellator.func_78381_a();
                        }
                        chance = 1;
                        this.field_72777_q.func_110434_K().func_110577_a(field_228414_i_);
                        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    float rainTicks = -((float)(this.field_72773_u & 0x1FF) + partialTicks) / 512.0f;
                    float texU = (float)(random.nextDouble() + (double)ticks * 0.01 * (double)((float)random.nextGaussian()));
                    float texV = (float)(random.nextDouble() + (double)(ticks * (float)random.nextGaussian()) * 0.001);
                    double xArea = (double)((float)x + 0.5f) - xIn;
                    double zArea = (double)((float)z + 0.5f) - zIn;
                    float totalArea = MathHelper.func_76133_a((double)(xArea * xArea + zArea * zArea)) / (float)particleArea;
                    float alpha = ((1.0f - totalArea * totalArea) * 0.3f + 0.5f) * rainStrength;
                    pos.func_181079_c(x, height, z);
                    int combinedLight = WorldRendererMixin.func_228421_a_((ILightReader)world, (BlockPos)pos);
                    int uLight = combinedLight >> 16 & 0xFFFF;
                    int vLight = (combinedLight & 0xFFFF) * 3;
                    int v = (uLight * 3 + 240) / 4;
                    int u = (vLight * 3 + 240) / 4;
                    bufferBuilder.func_225582_a_((double)x - xIn - rainSizeX + 0.5, (double)maxHeight - yIn, (double)z - zIn - rainSizeZ + 0.5).func_225583_a_(0.0f + texU, (float)minHeight * 0.25f + rainTicks + texV).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225587_b_(u, v).func_181675_d();
                    bufferBuilder.func_225582_a_((double)x - xIn + rainSizeX + 0.5, (double)maxHeight - yIn, (double)z - zIn + rainSizeZ + 0.5).func_225583_a_(1.0f + texU, (float)minHeight * 0.25f + rainTicks + texV).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225587_b_(u, v).func_181675_d();
                    bufferBuilder.func_225582_a_((double)x - xIn + rainSizeX + 0.5, (double)minHeight - yIn, (double)z - zIn + rainSizeZ + 0.5).func_225583_a_(1.0f + texU, (float)maxHeight * 0.25f + rainTicks + texV).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225587_b_(u, v).func_181675_d();
                    bufferBuilder.func_225582_a_((double)x - xIn - rainSizeX + 0.5, (double)minHeight - yIn, (double)z - zIn - rainSizeZ + 0.5).func_225583_a_(0.0f + texU, (float)maxHeight * 0.25f + rainTicks + texV).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225587_b_(u, v).func_181675_d();
                }
            }
            if (chance >= 0) {
                tessellator.func_78381_a();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.disableAlphaTest();
            lightMapIn.func_205108_b();
        }
    }
}

