/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.common.entity;

import com.blackgear.cavesandcliffs.common.block.CaveVinesBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoxEntity.EatBerriesGoal.class})
public class FoxEntityMixin
extends MoveToBlockGoal {
    @Shadow
    protected int field_220731_g;
    private final FoxEntity foxEntity;

    @Shadow
    protected void func_220730_m() {
        if (this.foxEntity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
            BlockState state = this.foxEntity.field_70170_p.func_180495_p(this.field_179494_b);
            if (state.func_177230_c().equals(Blocks.field_222434_lW)) {
                this.pickSweetBerries(state);
            } else if (CaveVinesBlock.hasGlowBerries(state)) {
                this.pickGlowBerry(state);
            }
        }
    }

    public FoxEntityMixin(CreatureEntity creature, double speedIn, int length) {
        super(creature, speedIn, length);
        this.foxEntity = (FoxEntity)creature.getEntity();
    }

    protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
        BlockState blockState = worldIn.func_180495_p(pos);
        return blockState.func_177230_c().equals(Blocks.field_222434_lW) && (Integer)blockState.func_177229_b((IProperty)SweetBerryBushBlock.field_220125_a) >= 2 || CaveVinesBlock.hasGlowBerries(blockState);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void tick(CallbackInfo info) {
        if (this.func_179487_f()) {
            if (this.field_220731_g >= 40) {
                this.func_220730_m();
            } else {
                ++this.field_220731_g;
            }
        } else if (!this.func_179487_f() && this.foxEntity.field_70170_p.field_73012_v.nextFloat() < 0.05f) {
            this.foxEntity.func_184185_a(SoundEvents.field_219628_dB, 1.0f, 1.0f);
        }
    }

    private void pickGlowBerry(BlockState state) {
        CaveVinesBlock.onBlockActivated(state, this.foxEntity.field_70170_p, this.field_179494_b);
    }

    private void pickSweetBerries(BlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)SweetBerryBushBlock.field_220125_a);
        state.func_206870_a((IProperty)SweetBerryBushBlock.field_220125_a, (Comparable)Integer.valueOf(1));
        int berries = 1 + this.foxEntity.field_70170_p.field_73012_v.nextInt(2) + (age == 3 ? 1 : 0);
        ItemStack heldItem = this.foxEntity.func_184582_a(EquipmentSlotType.MAINHAND);
        if (heldItem.func_190926_b()) {
            this.foxEntity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_222112_pR));
            --berries;
        }
        if (berries > 0) {
            Block.func_180635_a((World)this.foxEntity.field_70170_p, (BlockPos)this.field_179494_b, (ItemStack)new ItemStack((IItemProvider)Items.field_222112_pR, berries));
        }
        this.foxEntity.func_184185_a(SoundEvents.field_219693_lB, 1.0f, 1.0f);
        this.foxEntity.field_70170_p.func_180501_a(this.field_179494_b, (BlockState)state.func_206870_a((IProperty)SweetBerryBushBlock.field_220125_a, (Comparable)Integer.valueOf(1)), 2);
    }
}

