/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.common.item;

import com.blackgear.cavesandcliffs.common.block.util.BucketPickup;
import com.blackgear.cavesandcliffs.common.item.util.ItemUtils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BucketItem.class})
public class BucketItemMixin
extends Item {
    private final Fluid containedBlock;

    public BucketItemMixin(Fluid containedFluidIn, Item.Properties properties) {
        super(properties);
        this.containedBlock = containedFluidIn;
    }

    @Inject(method={"onItemRightClick"}, at={@At(value="HEAD")}, cancellable=true)
    public void useItem(World worldIn, PlayerEntity playerIn, Hand handIn, CallbackInfoReturnable<ActionResult<ItemStack>> info) {
        RayTraceResult rayTraceResult;
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        ActionResult bucketUse = ForgeEventFactory.onBucketUse((PlayerEntity)playerIn, (World)worldIn, (ItemStack)heldItem, (RayTraceResult)(rayTraceResult = BucketItemMixin.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)(this.containedBlock == Fluids.field_204541_a ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE))));
        if (bucketUse != null) {
            info.setReturnValue((Object)bucketUse);
        }
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.MISS) {
            info.setReturnValue((Object)ActionResult.func_226250_c_((Object)heldItem));
        } else if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            info.setReturnValue((Object)ActionResult.func_226250_c_((Object)heldItem));
        } else {
            BucketPickup bucketPickup;
            ItemStack bucket;
            BlockState clickedBlockState;
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
            BlockPos clickedPos = blockRayTraceResult.func_216350_a();
            Direction facingDirection = blockRayTraceResult.func_216354_b();
            BlockPos posOffset = clickedPos.func_177972_a(facingDirection);
            if (worldIn.func_175660_a(playerIn, clickedPos) && playerIn.func_175151_a(posOffset, facingDirection, heldItem) && this.containedBlock == Fluids.field_204541_a && (clickedBlockState = worldIn.func_180495_p(clickedPos)).func_177230_c() instanceof BucketPickup && !(bucket = (bucketPickup = (BucketPickup)clickedBlockState.func_177230_c()).pickupBlock((IWorld)worldIn, clickedPos, clickedBlockState)).func_190926_b()) {
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                bucketPickup.getPickupSound().ifPresent(sound -> playerIn.func_184185_a(sound, 1.0f, 1.0f));
                ItemStack filledBucket = ItemUtils.createFilledResult(heldItem, playerIn, bucket);
                if (!worldIn.field_72995_K) {
                    CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)playerIn, bucket);
                }
                info.setReturnValue((Object)ActionResult.func_226248_a_((Object)filledBucket));
            }
        }
    }
}

