/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.common.world.gen;

import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkGenerator.class})
public abstract class ChunkGeneratorMixin {
    @Shadow
    @Final
    protected BiomeProvider field_222542_c;
    @Shadow
    @Final
    protected long field_222541_b;

    @Shadow
    public abstract int func_222530_f();

    private void applyBiomeStructures(BiomeManager biomeManager, IChunk chunkIn, ChunkGenerator<?> generator, TemplateManager templateManager, CallbackInfo info) {
        for (Structure structure : Feature.field_202300_at.values()) {
            StructureStart startFactory;
            if (!generator.func_202090_b().func_205004_a(structure)) continue;
            StructureStart structureStart = chunkIn.func_201585_a(structure.func_143025_a());
            int i = structureStart != null ? structureStart.func_227457_j_() : 0;
            SharedSeedRandom sharedSeedRandom = new SharedSeedRandom();
            ChunkPos chunkPos = chunkIn.func_76632_l();
            StructureStart dummyStructure = StructureStart.field_214630_a;
            Biome surfaceBiome = biomeManager.func_226836_a_(new BlockPos(chunkPos.func_180334_c() + 9, 28, chunkPos.func_180333_d() + 9));
            Biome caveBiome = biomeManager.func_226836_a_(new BlockPos(chunkPos.func_180334_c() + 9, 8, chunkPos.func_180333_d() + 9));
            if (structure.func_225558_a_(biomeManager, generator, (Random)sharedSeedRandom, chunkPos.field_77276_a, chunkPos.field_77275_b, surfaceBiome)) {
                startFactory = structure.func_214557_a().create(structure, chunkPos.field_77276_a, chunkPos.field_77275_b, MutableBoundingBox.func_78887_a(), i, generator.func_202089_c());
                startFactory.func_214625_a((ChunkGenerator)this, templateManager, chunkPos.field_77276_a, chunkPos.field_77275_b, surfaceBiome);
                StructureStart structureStart2 = dummyStructure = startFactory.func_75069_d() ? startFactory : StructureStart.field_214630_a;
            }
            if (structure.func_225558_a_(biomeManager, generator, (Random)sharedSeedRandom, chunkPos.field_77276_a, chunkPos.field_77275_b, caveBiome)) {
                startFactory = structure.func_214557_a().create(structure, chunkPos.field_77276_a, chunkPos.field_77275_b, MutableBoundingBox.func_78887_a(), i, generator.func_202089_c());
                startFactory.func_214625_a((ChunkGenerator)this, templateManager, chunkPos.field_77276_a, chunkPos.field_77275_b, caveBiome);
                dummyStructure = startFactory.func_75069_d() ? startFactory : StructureStart.field_214630_a;
            }
            chunkIn.func_201584_a(structure.func_143025_a(), dummyStructure);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"generateStructures"})
    private void applyStructures(BiomeManager biomeManager, IChunk chunkIn, ChunkGenerator<?> generator, TemplateManager templateManager, CallbackInfo info) {
        for (Structure structure : Feature.field_202300_at.values()) {
            StructureStart startFactory;
            StructureStart structureStart = chunkIn.func_201585_a(structure.func_143025_a());
            ChunkPos chunkPos = chunkIn.func_76632_l();
            Biome surfaceBiome = biomeManager.func_226836_a_(new BlockPos(chunkPos.func_180334_c() + 9, generator.func_222530_f(), chunkPos.func_180333_d() + 9));
            Biome caveBiome = biomeManager.func_226836_a_(new BlockPos(chunkPos.func_180334_c() + 9, 0, chunkPos.func_180333_d() + 9));
            StructureStart structureStartIn = StructureStart.field_214630_a;
            int ref = structureStart != null ? structureStart.func_227457_j_() : 0;
            SharedSeedRandom sharedSeedRandom = new SharedSeedRandom();
            if (structure.func_225558_a_(biomeManager, generator, (Random)sharedSeedRandom, chunkPos.field_77276_a, chunkPos.field_77275_b, surfaceBiome)) {
                startFactory = structure.func_214557_a().create(structure, chunkPos.field_77276_a, chunkPos.field_77275_b, MutableBoundingBox.func_78887_a(), ref, generator.func_202089_c());
                startFactory.func_214625_a((ChunkGenerator)this, templateManager, chunkPos.field_77276_a, chunkPos.field_77275_b, surfaceBiome);
                StructureStart structureStart2 = structureStartIn = startFactory.func_75069_d() ? startFactory : StructureStart.field_214630_a;
            }
            if (structure.func_225558_a_(biomeManager, generator, (Random)sharedSeedRandom, chunkPos.field_77276_a, chunkPos.field_77275_b, caveBiome)) {
                startFactory = structure.func_214557_a().create(structure, chunkPos.field_77276_a, chunkPos.field_77275_b, MutableBoundingBox.func_78887_a(), ref, generator.func_202089_c());
                startFactory.func_214625_a((ChunkGenerator)this, templateManager, chunkPos.field_77276_a, chunkPos.field_77275_b, caveBiome);
                structureStartIn = startFactory.func_75069_d() ? startFactory : StructureStart.field_214630_a;
            }
            chunkIn.func_201584_a(structure.func_143025_a(), structureStartIn);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"decorate(Lnet/minecraft/world/gen/WorldGenRegion;)V"}, cancellable=true)
    private void applyBiomeDecoration(WorldGenRegion region, CallbackInfo info) {
        int chunkX = region.func_201679_a();
        int chunkZ = region.func_201680_b();
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BlockPos blockpos = new BlockPos(x, 0, z);
        Biome surfaceBiome = this.field_222542_c.func_225526_b_((chunkX << 2) + 2, 16, (chunkZ << 2) + 2);
        Biome caveBiome = this.field_222542_c.func_225526_b_((chunkX << 2) + 2, 2, (chunkZ << 2) + 2);
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        long seed = sharedseedrandom.func_202424_a(region.func_72905_C(), x, z);
        if (caveBiome == surfaceBiome) {
            return;
        }
        for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
            try {
                surfaceBiome.func_203608_a(decoration, (ChunkGenerator)this, (IWorld)region, seed, sharedseedrandom, blockpos);
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)exception, (String)"Surface Biome decoration");
                crashreport.func_85058_a("Generation").func_71507_a("CenterX", (Object)chunkX).func_71507_a("CenterZ", (Object)chunkZ).func_71507_a("Step", (Object)decoration).func_71507_a("Seed", (Object)seed).func_71507_a("Biome", (Object)surfaceBiome);
                throw new ReportedException(crashreport);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"func_225550_a_(Lnet/minecraft/world/biome/BiomeManager;Lnet/minecraft/world/chunk/IChunk;Lnet/minecraft/world/gen/GenerationStage$Carving;)V"}, cancellable=true)
    public void applyBiomeCarvers(BiomeManager manager, IChunk chunkIn, GenerationStage.Carving carver, CallbackInfo info) {
        BiomeManager biomeManager = manager.func_226835_a_(this.field_222542_c);
        SharedSeedRandom sharedSeedRandom = new SharedSeedRandom();
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int x = chunkpos.field_77276_a;
        int z = chunkpos.field_77275_b;
        Biome biome = this.field_222542_c.func_225526_b_(chunkpos.field_77276_a << 2, 16, chunkpos.field_77275_b << 2);
        BitSet bitSet = chunkIn.func_205749_a(carver);
        for (int xChunk = x - 8; xChunk <= x + 8; ++xChunk) {
            for (int zChunk = z - 8; zChunk <= z + 8; ++zChunk) {
                List list = biome.func_203603_a(carver);
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    int index = listIterator.nextIndex();
                    ConfiguredCarver configuredCarver = (ConfiguredCarver)listIterator.next();
                    sharedSeedRandom.func_202425_c(this.field_222541_b + (long)index, xChunk, zChunk);
                    if (!configuredCarver.func_222730_a((Random)sharedSeedRandom, xChunk, zChunk)) continue;
                    configuredCarver.func_227207_a_(chunkIn, arg_0 -> ((BiomeManager)biomeManager).func_226836_a_(arg_0), (Random)sharedSeedRandom, this.func_222530_f(), xChunk, zChunk, x, z, bitSet);
                }
            }
        }
    }
}

