/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.client.entity.model;

import com.blackgear.cavesandcliffs.common.entities.passive.axolotl.AxolotlEntity;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AxolotlModel<T extends AxolotlEntity>
extends AgeableModel<T> {
    private final ModelRenderer tail;
    private final ModelRenderer leftHindLeg;
    private final ModelRenderer rightHindLeg;
    private final ModelRenderer leftFrontLeg;
    private final ModelRenderer rightFrontLeg;
    private final ModelRenderer body;
    private final ModelRenderer head;
    private final ModelRenderer topGills;
    private final ModelRenderer leftGills;
    private final ModelRenderer rightGills;

    public AxolotlModel() {
        super(true, 8.0f, 3.35f);
        this.field_78089_u = 64;
        this.field_78090_t = 64;
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 20.0f, 5.0f);
        this.body.func_78784_a(0, 11).func_228303_a_(-4.0f, -2.0f, -9.0f, 8.0f, 4.0f, 10.0f, 0.0f, false);
        this.body.func_78784_a(2, 17).func_228303_a_(0.0f, -3.0f, -8.0f, 0.0f, 5.0f, 9.0f, 0.0f, false);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, 0.0f, -9.0f);
        this.head.func_78784_a(0, 1).func_228303_a_(-4.0f, -3.0f, -5.0f, 8.0f, 5.0f, 5.0f, 0.0f, false);
        this.topGills = new ModelRenderer((Model)this);
        this.topGills.func_78793_a(0.0f, -3.0f, -1.0f);
        this.topGills.func_78784_a(3, 37).func_228303_a_(-4.0f, -3.0f, 0.0f, 8.0f, 3.0f, 0.0f, 0.001f, false);
        this.leftGills = new ModelRenderer((Model)this);
        this.leftGills.func_78793_a(-4.0f, 0.0f, -1.0f);
        this.leftGills.func_78784_a(0, 40).func_228303_a_(-3.0f, -5.0f, 0.0f, 3.0f, 7.0f, 0.0f, 0.001f, false);
        this.rightGills = new ModelRenderer((Model)this);
        this.rightGills.func_78793_a(4.0f, 0.0f, -1.0f);
        this.rightGills.func_78784_a(11, 40).func_228303_a_(0.0f, -5.0f, 0.0f, 3.0f, 7.0f, 0.0f, 0.001f, false);
        this.rightHindLeg = new ModelRenderer((Model)this);
        this.rightHindLeg.func_78793_a(-3.5f, 1.0f, -1.0f);
        this.rightHindLeg.func_78784_a(2, 13).func_228303_a_(-1.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, 0.001f, false);
        this.leftHindLeg = new ModelRenderer((Model)this);
        this.leftHindLeg.func_78793_a(3.5f, 1.0f, -1.0f);
        this.leftHindLeg.func_78784_a(2, 13).func_228303_a_(-1.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, 0.001f, false);
        this.rightFrontLeg = new ModelRenderer((Model)this);
        this.rightFrontLeg.func_78793_a(-3.5f, 1.0f, -8.0f);
        this.rightFrontLeg.func_78784_a(2, 13).func_228303_a_(-2.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, 0.001f, false);
        this.leftFrontLeg = new ModelRenderer((Model)this);
        this.leftFrontLeg.func_78793_a(3.5f, 1.0f, -8.0f);
        this.leftFrontLeg.func_78784_a(2, 13).func_228303_a_(-2.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, 0.001f, false);
        this.tail = new ModelRenderer((Model)this);
        this.tail.func_78793_a(0.0f, 0.0f, 1.0f);
        this.tail.func_78784_a(2, 19).func_228303_a_(0.0f, -3.0f, 0.0f, 0.0f, 5.0f, 12.0f, 0.0f, false);
        this.body.func_78792_a(this.head);
        this.head.func_78792_a(this.topGills);
        this.head.func_78792_a(this.leftGills);
        this.head.func_78792_a(this.rightGills);
        this.body.func_78792_a(this.rightHindLeg);
        this.body.func_78792_a(this.leftHindLeg);
        this.body.func_78792_a(this.rightFrontLeg);
        this.body.func_78792_a(this.leftFrontLeg);
        this.body.func_78792_a(this.tail);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body);
    }

    public void setRotationAngles(AxolotlEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    private void setupInitialAnimationValues(float yawIn, float pitchIn) {
        this.body.field_78800_c = 0.0f;
        this.head.field_78797_d = 0.0f;
        this.body.field_78797_d = 20.0f;
        this.body.func_78793_a(pitchIn * ((float)Math.PI / 180), yawIn * ((float)Math.PI / 180), 0.0f);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.leftHindLeg.func_78793_a(0.0f, 0.0f, 0.0f);
        this.rightHindLeg.func_78793_a(0.0f, 0.0f, 0.0f);
        this.leftFrontLeg.func_78793_a(0.0f, 0.0f, 0.0f);
        this.rightFrontLeg.func_78793_a(0.0f, 0.0f, 0.0f);
        this.leftGills.func_78793_a(0.0f, 0.0f, 0.0f);
        this.rightGills.func_78793_a(0.0f, 0.0f, 0.0f);
        this.topGills.func_78793_a(0.0f, 0.0f, 0.0f);
        this.tail.func_78793_a(0.0f, 0.0f, 0.0f);
    }

    private void setupLayStillOnGroundAnimation(float ageInTicks) {
        float pitch = ageInTicks * 0.09f;
        float sin = MathHelper.func_76126_a((float)pitch);
        float cos = MathHelper.func_76134_b((float)pitch);
        float angle = sin * sin - 2.0f * sin;
        float gillRotation = cos * cos - 3.0f * sin;
        this.head.field_78795_f = -0.09f * angle;
        this.head.field_78808_h = -0.2f;
        this.tail.field_78796_g = -0.1f + 0.1f * angle;
        this.topGills.field_78795_f = 0.6f + 0.05f * gillRotation;
        this.leftGills.field_78796_g = -this.topGills.field_78795_f;
        this.rightGills.field_78796_g = -this.leftGills.field_78796_g;
        this.leftHindLeg.func_78793_a(1.1f, 1.0f, 0.0f);
        this.leftFrontLeg.func_78793_a(0.8f, 2.3f, -0.5f);
        this.applyMirrorLegRotations();
    }

    private void setupGroundCrawlingAnimation(float ageInTicks) {
        float yaw = ageInTicks * 0.11f;
        float cos = MathHelper.func_76134_b((float)yaw);
        float hindYaw = (cos * cos - 2.0f * cos) / 5.0f;
        float frontYaw = 0.7f * cos;
        this.tail.field_78796_g = this.head.field_78796_g = 0.09f * cos;
        this.topGills.field_78795_f = 0.6f - 0.08f * (cos * cos + 2.0f * MathHelper.func_76126_a((float)yaw));
        this.leftGills.field_78796_g = -this.topGills.field_78795_f;
        this.rightGills.field_78796_g = -this.leftGills.field_78796_g;
        this.leftHindLeg.func_78793_a(0.9424779f, 1.5f - hindYaw, -0.1f);
        this.leftFrontLeg.func_78793_a(1.0995574f, 1.5707964f - frontYaw, 0.0f);
        this.rightHindLeg.func_78793_a(this.leftHindLeg.field_78795_f, -1.0f - hindYaw, 0.0f);
        this.rightFrontLeg.func_78793_a(this.leftFrontLeg.field_78795_f, -1.5707964f - frontYaw, 0.0f);
    }

    private void setupWaterHoveringAnimation(float ageInTicks) {
        float pitch = ageInTicks * 0.075f;
        float cos = MathHelper.func_76134_b((float)pitch);
        float sin = MathHelper.func_76126_a((float)pitch) * 0.15f;
        this.body.field_78795_f = -0.15f + 0.075f * cos;
        ModelRenderer body = this.body;
        body.field_78797_d -= sin;
        this.head.field_78795_f = -this.body.field_78795_f;
        this.topGills.field_78795_f = 0.2f * cos;
        this.leftGills.field_78796_g = -0.3f * cos - 0.19f;
        this.rightGills.field_78796_g = -this.leftGills.field_78796_g;
        this.leftHindLeg.func_78793_a(2.3561945f - cos * 0.11f, 0.47123894f, 1.7278761f);
        this.leftFrontLeg.func_78793_a(0.7853982f - cos * 0.2f, 2.042035f, 0.0f);
        this.applyMirrorLegRotations();
        this.tail.field_78796_g = 0.5f * cos;
    }

    private void setupSwimmingAnimation(float yawIn, float pitchIn) {
        float yaw = yawIn * 0.33f;
        float sin = MathHelper.func_76126_a((float)yaw);
        float cos = MathHelper.func_76134_b((float)yaw);
        float pitch = 0.13f * sin;
        this.body.field_78795_f = pitchIn * ((float)Math.PI / 180) + pitch;
        this.head.field_78795_f = -pitch * 1.8f;
        ModelRenderer body = this.body;
        body.field_78797_d -= 0.45f * cos;
        this.topGills.field_78795_f = -0.5f * sin - 0.8f;
        this.leftGills.field_78796_g = 0.3f * sin + 0.9f;
        this.rightGills.field_78796_g = -this.leftGills.field_78796_g;
        this.tail.field_78796_g = 0.3f * MathHelper.func_76134_b((float)(yaw * 0.9f));
        this.leftHindLeg.func_78793_a(1.8849558f, -0.4f * sin, 1.5707964f);
        this.leftFrontLeg.func_78793_a(1.8849558f, -0.2f * cos - 0.1f, 1.5707964f);
        this.applyMirrorLegRotations();
    }

    private void setupPlayDeadAnimation() {
        this.leftHindLeg.func_78793_a(1.4137167f, 1.0995574f, 0.7853982f);
        this.leftFrontLeg.func_78793_a(0.7853982f, 2.042035f, 0.0f);
        this.body.field_78795_f = -0.15f;
        this.body.field_78808_h = 0.35f;
        this.applyMirrorLegRotations();
    }

    private void applyMirrorLegRotations() {
        this.rightHindLeg.func_78793_a(this.leftHindLeg.field_78800_c, -this.leftHindLeg.field_78797_d, -this.leftHindLeg.field_78798_e);
        this.rightFrontLeg.func_78793_a(this.leftFrontLeg.field_78800_c, -this.leftFrontLeg.field_78797_d, -this.leftFrontLeg.field_78798_e);
    }
}

