/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.client.particles;

import com.blackgear.cavesandcliffs.core.registries.CCBParticleTypes;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CCBDripParticle
extends SpriteTexturedParticle {
    private final Fluid fluid;
    protected boolean isGlowing;

    private CCBDripParticle(ClientWorld world, double x, double y, double z, Fluid fluid) {
        super(world, x, y, z);
        this.func_187115_a(0.01f, 0.01f);
        this.field_70545_g = 0.06f;
        this.fluid = fluid;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    protected int func_189214_a(float partialTick) {
        return this.isGlowing ? 240 : super.func_189214_a(partialTick);
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.preMoveUpdate();
        if (!this.field_187133_m) {
            this.field_187130_j -= (double)this.field_70545_g;
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.postMoveUpdate();
            if (!this.field_187133_m) {
                this.field_187129_i *= (double)0.98f;
                this.field_187130_j *= (double)0.98f;
                this.field_187131_k *= (double)0.98f;
                BlockPos blockPos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
                FluidState fluidState = this.field_187122_b.func_204610_c(blockPos);
                if (fluidState.func_206886_c() == this.fluid && this.field_187127_g < (double)((float)blockPos.func_177956_o() + fluidState.func_215679_a((IBlockReader)this.field_187122_b, blockPos))) {
                    this.func_187112_i();
                }
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.field_70547_e-- <= 0) {
            this.func_187112_i();
        }
    }

    protected void postMoveUpdate() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SporeBlossomFallFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;
        private final Random rand;

        public SporeBlossomFallFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
            this.rand = new Random();
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            int maxAge = (int)(64.0f / MathUtils.randomBetween(this.rand, 0.1f, 0.9f));
            FallingParticle dripParticle = new FallingParticle(worldIn, x, y, z, Fluids.field_204541_a, maxAge);
            ((CCBDripParticle)dripParticle).field_70545_g = 0.005f;
            dripParticle.func_70538_b(0.32f, 0.5f, 0.22f);
            dripParticle.func_217568_a(this.spriteSet);
            return dripParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DripHangParticle
    extends CCBDripParticle {
        private final IParticleData fallingParticle;

        private DripHangParticle(ClientWorld world, double x, double y, double z, Fluid fluid, IParticleData particleData) {
            super(world, x, y, z, fluid);
            this.fallingParticle = particleData;
            this.field_70545_g *= 0.02f;
            this.field_70547_e = 40;
        }

        @Override
        protected void preMoveUpdate() {
            if (this.field_70547_e-- <= 0) {
                this.func_187112_i();
                this.field_187122_b.func_195594_a(this.fallingParticle, this.field_187126_f, this.field_187127_g, this.field_187128_h, this.field_187129_i, this.field_187130_j, this.field_187131_k);
            }
        }

        @Override
        protected void postMoveUpdate() {
            this.field_187129_i *= 0.02;
            this.field_187130_j *= 0.02;
            this.field_187131_k *= 0.02;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CoolingDripHangParticle
    extends DripHangParticle {
        private CoolingDripHangParticle(ClientWorld world, double x, double y, double z, Fluid fluid, IParticleData particleData) {
            super(world, x, y, z, fluid, particleData);
        }

        @Override
        protected void preMoveUpdate() {
            this.field_70552_h = 1.0f;
            this.field_70553_i = 16.0f / (float)(40 - this.field_70547_e + 16);
            this.field_70551_j = 4.0f / (float)(40 - this.field_70547_e + 8);
            super.preMoveUpdate();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FallAndLandParticle
    extends FallingParticle {
        protected final IParticleData landParticle;

        private FallAndLandParticle(ClientWorld world, double x, double y, double z, Fluid fluid, IParticleData particleData) {
            super(world, x, y, z, fluid);
            this.landParticle = particleData;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.field_187132_l) {
                this.func_187112_i();
                this.field_187122_b.func_195594_a(this.landParticle, this.field_187126_f, this.field_187127_g, this.field_187128_h, 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FallingParticle
    extends CCBDripParticle {
        private FallingParticle(ClientWorld world, double x, double y, double z, Fluid fluid) {
            this(world, x, y, z, fluid, (int)(64.0 / (Math.random() * 0.8 + 0.2)));
        }

        private FallingParticle(ClientWorld world, double x, double y, double z, Fluid fluid, int maxAge) {
            super(world, x, y, z, fluid);
            this.field_70547_e = maxAge;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.field_187132_l) {
                this.func_187112_i();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DripstoneWaterHangFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public DripstoneWaterHangFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DripHangParticle dripParticle = new DripHangParticle(worldIn, x, y, z, (Fluid)Fluids.field_204546_a, (IParticleData)CCBParticleTypes.FALLING_DRIPSTONE_WATER.get());
            dripParticle.func_70538_b(0.2f, 0.3f, 1.0f);
            dripParticle.func_217568_a(this.spriteSet);
            return dripParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DripstoneWaterFallFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public DripstoneWaterFallFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DripstoneFallAndLandParticle dripParticle = new DripstoneFallAndLandParticle(worldIn, x, y, z, (Fluid)Fluids.field_204546_a, (IParticleData)ParticleTypes.field_218422_X);
            dripParticle.func_70538_b(0.2f, 0.3f, 1.0f);
            dripParticle.func_217568_a(this.spriteSet);
            return dripParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DripstoneLavaHangFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public DripstoneLavaHangFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CoolingDripHangParticle dripParticle = new CoolingDripHangParticle(worldIn, x, y, z, (Fluid)Fluids.field_204547_b, (IParticleData)CCBParticleTypes.FALLING_DRIPSTONE_LAVA.get());
            dripParticle.func_217568_a(this.spriteSet);
            return dripParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DripstoneLavaFallFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite spriteSet;

        public DripstoneLavaFallFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DripstoneFallAndLandParticle dripParticle = new DripstoneFallAndLandParticle(worldIn, x, y, z, (Fluid)Fluids.field_204547_b, (IParticleData)ParticleTypes.field_218424_l);
            dripParticle.func_70538_b(1.0f, 0.2857143f, 0.083333336f);
            dripParticle.func_217568_a(this.spriteSet);
            return dripParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DripstoneFallAndLandParticle
    extends FallAndLandParticle {
        private DripstoneFallAndLandParticle(ClientWorld world, double x, double y, double z, Fluid fluid, IParticleData particleData) {
            super(world, x, y, z, fluid, particleData);
        }

        @Override
        protected void postMoveUpdate() {
            if (this.field_187132_l) {
                this.func_187112_i();
                this.field_187122_b.func_195594_a(this.landParticle, this.field_187126_f, this.field_187127_g, this.field_187128_h, 0.0, 0.0, 0.0);
                SoundEvent sound = this.getFluid() == Fluids.field_204547_b ? (SoundEvent)CCBSoundEvents.BLOCK_POINTED_DRIPSTONE_DRIP_LAVA.get() : (SoundEvent)CCBSoundEvents.BLOCK_POINTED_DRIPSTONE_DRIP_WATER.get();
                float volume = MathUtils.randomBetween(this.field_187136_p, 0.3f, 1.0f);
                this.field_187122_b.func_184134_a(this.field_187126_f, this.field_187127_g, this.field_187128_h, sound, SoundCategory.BLOCKS, volume, 1.0f, false);
            }
        }
    }
}

