/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.PointedDripstoneBlock;
import com.blackgear.cavesandcliffs.common.utils.CauldronInteraction;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractCauldronBlock
extends CauldronBlock {
    private static final VoxelShape INSIDE = Block.func_208617_a((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private final Map<Item, CauldronInteraction> interactions;

    public AbstractCauldronBlock(AbstractBlock.Properties properties, Map<Item, CauldronInteraction> interactions) {
        super(properties);
        this.interactions = interactions;
    }

    protected double getContentHeight(BlockState state) {
        return 0.0;
    }

    protected boolean isEntityInsideContent(BlockState state, BlockPos pos, Entity entity) {
        return entity.func_226278_cu_() < (double)pos.func_177956_o() + this.getContentHeight(state) && entity.func_174813_aQ().field_72337_e > (double)pos.func_177956_o() + 0.25;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemStack = player.func_184586_b(handIn);
        CauldronInteraction interaction = this.interactions.get(itemStack.func_77973_b());
        return interaction.interact(state, worldIn, pos, player, handIn, itemStack);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return INSIDE;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public abstract boolean isFull(BlockState var1);

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        Fluid fluid;
        BlockPos blockPos = PointedDripstoneBlock.findStalactiteTipAboveCauldron((World)worldIn, pos);
        if (blockPos != null && (fluid = PointedDripstoneBlock.getCauldronFillFluidType((World)worldIn, blockPos)) != Fluids.field_204541_a && this.canReceiveStalactiteDrip(fluid)) {
            this.receiveStalactiteDrip(state, (World)worldIn, pos, fluid);
        }
    }

    public boolean canReceiveStalactiteDrip(Fluid fluid) {
        return false;
    }

    protected void receiveStalactiteDrip(BlockState state, World worldIn, BlockPos pos, Fluid fluid) {
    }

    public void handlePrecipitation(BlockState state, World world, BlockPos pos, Biome.RainType precipitation) {
    }
}

