/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.DirectionUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.FluidUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MultifaceBlock
extends Block {
    private static final VoxelShape UP_SHAPE = Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = SixWayBlock.field_196491_B;
    private static final Map<Direction, VoxelShape> SHAPE_TO_DIRECTION_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.NORTH, NORTH_SHAPE);
        enumMap.put(Direction.EAST, EAST_SHAPE);
        enumMap.put(Direction.SOUTH, SOUTH_SHAPE);
        enumMap.put(Direction.WEST, WEST_SHAPE);
        enumMap.put(Direction.UP, UP_SHAPE);
        enumMap.put(Direction.DOWN, DOWN_SHAPE);
    });
    public static final Direction[] DIRECTIONS = Direction.values();
    private static ImmutableMap<BlockState, VoxelShape> shapesCache;
    private static boolean canRotate;
    private static boolean canMirrorX;
    private static boolean canMirrorZ;

    public MultifaceBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j(MultifaceBlock.getDefaultMultifaceState((StateContainer<Block, BlockState>)this.field_176227_L));
        shapesCache = BlockUtils.getShapeForEachState(this, MultifaceBlock::calculateMultifaceShape);
        canRotate = DirectionUtils.streamPlane(Direction.Plane.HORIZONTAL).allMatch(this::isFaceSupported);
        canMirrorX = DirectionUtils.streamPlane(Direction.Plane.HORIZONTAL).filter((Predicate<Direction>)Direction.Axis.X).filter(this::isFaceSupported).count() % 2L == 0L;
        canMirrorZ = DirectionUtils.streamPlane(Direction.Plane.HORIZONTAL).filter((Predicate<Direction>)Direction.Axis.Z).filter(this::isFaceSupported).count() % 2L == 0L;
    }

    protected boolean isFaceSupported(Direction direction) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        for (Direction direction : DIRECTIONS) {
            if (!this.isFaceSupported(direction)) continue;
            builder.func_206894_a(new Property[]{MultifaceBlock.getFaceProperty(direction)});
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return MultifaceBlock.hasFace(stateIn, facing) && !MultifaceBlock.canAttachTo((IBlockReader)worldIn, facing, facingPos, facingState) ? MultifaceBlock.removeFace(stateIn, MultifaceBlock.getFaceProperty(facing)) : stateIn;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)shapesCache.get((Object)state);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        boolean isInValidPosition = false;
        for (Direction direction : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(state, direction)) continue;
            BlockPos blockPos = pos.func_177972_a(direction);
            if (!MultifaceBlock.canAttachTo((IBlockReader)worldIn, direction, blockPos, worldIn.func_180495_p(blockPos))) {
                return false;
            }
            isInValidPosition = true;
        }
        return isInValidPosition;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return MultifaceBlock.hasAnyVacantFace(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        return Arrays.stream(context.func_196009_e()).map(direction -> this.getStateForPlacement(state, (IBlockReader)world, pos, (Direction)direction)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockState state, IBlockReader reader, BlockPos pos, Direction direction) {
        BlockState blockState;
        if (!this.isFaceSupported(direction)) {
            return null;
        }
        if (state.func_177230_c() == this) {
            if (MultifaceBlock.hasFace(state, direction)) {
                return null;
            }
            blockState = state;
        } else {
            blockState = this.isWaterloggable() && FluidUtils.isSourceOfType(state.func_204520_s(), (Fluid)Fluids.field_204546_a) ? (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)) : this.func_176223_P();
        }
        BlockPos offset = pos.func_177972_a(direction);
        return MultifaceBlock.canAttachTo(reader, direction, offset, reader.func_180495_p(offset)) ? (BlockState)blockState.func_206870_a((Property)MultifaceBlock.getFaceProperty(direction), (Comparable)Boolean.valueOf(true)) : null;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        if (!canRotate) {
            return state;
        }
        return this.mapDirections(state, arg_0 -> ((Rotation)rot).func_185831_a(arg_0));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        if (mirrorIn == Mirror.FRONT_BACK && !canMirrorX) {
            return state;
        }
        if (mirrorIn == Mirror.LEFT_RIGHT && !canMirrorZ) {
            return state;
        }
        return this.mapDirections(state, arg_0 -> ((Mirror)mirrorIn).func_185803_b(arg_0));
    }

    private BlockState mapDirections(BlockState state, Function<Direction, Direction> function) {
        BlockState blockState = state;
        for (Direction direction : DIRECTIONS) {
            if (!this.isFaceSupported(direction)) continue;
            blockState = (BlockState)blockState.func_206870_a((Property)MultifaceBlock.getFaceProperty(function.apply(direction)), state.func_177229_b((Property)MultifaceBlock.getFaceProperty(direction)));
        }
        return blockState;
    }

    public boolean spreadFromRandomFaceTowardRandomDirection(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        ArrayList directions = Lists.newArrayList((Object[])DIRECTIONS);
        Collections.shuffle(directions);
        return directions.stream().filter(direction -> MultifaceBlock.hasFace(state, direction)).anyMatch(direction -> this.spreadFromFaceTowardRandomDirection(state, (IWorld)worldIn, pos, (Direction)direction, rand));
    }

    public boolean spreadFromFaceTowardRandomDirection(BlockState state, IWorld worldIn, BlockPos pos, Direction direction, Random rand) {
        List<Direction> directions = Arrays.asList(DIRECTIONS);
        Collections.shuffle(directions, rand);
        return directions.stream().anyMatch(directionx -> this.spreadFromFaceTowardDirection(state, worldIn, pos, direction, (Direction)directionx));
    }

    public boolean spreadFromFaceTowardDirection(BlockState state, IWorld worldIn, BlockPos pos, Direction face, Direction direction) {
        Optional<Pair<BlockPos, Direction>> optional = this.getSpreadFromFaceTowardDirection(state, (IBlockReader)worldIn, pos, face, direction);
        if (optional.isPresent()) {
            Pair<BlockPos, Direction> pair = optional.get();
            return this.spreadToFace(worldIn, (BlockPos)pair.getFirst(), (Direction)pair.getSecond());
        }
        return false;
    }

    protected boolean canSpread(BlockState state, IBlockReader readerIn, BlockPos pos, Direction direction) {
        return Stream.of(DIRECTIONS).anyMatch(facing -> this.getSpreadFromFaceTowardDirection(state, readerIn, pos, direction, (Direction)facing).isPresent());
    }

    private Optional<Pair<BlockPos, Direction>> getSpreadFromFaceTowardDirection(BlockState state, IBlockReader reader, BlockPos pos, Direction face, Direction direction) {
        if (direction.func_176740_k() != face.func_176740_k() && MultifaceBlock.hasFace(state, face) && !MultifaceBlock.hasFace(state, direction)) {
            Direction surfaceDirection;
            if (this.canSpreadToFace(reader, pos, direction)) {
                return Optional.of(Pair.of((Object)pos, (Object)direction));
            }
            BlockPos offset = pos.func_177972_a(direction);
            if (this.canSpreadToFace(reader, offset, face)) {
                return Optional.of(Pair.of((Object)offset, (Object)face));
            }
            BlockPos facePos = offset.func_177972_a(face);
            return this.canSpreadToFace(reader, facePos, surfaceDirection = direction.func_176734_d()) ? Optional.of(Pair.of((Object)facePos, (Object)surfaceDirection)) : Optional.empty();
        }
        return Optional.empty();
    }

    private boolean canSpreadToFace(IBlockReader reader, BlockPos pos, Direction direction) {
        BlockState state = reader.func_180495_p(pos);
        if (!this.canSpreadInto(state)) {
            return false;
        }
        BlockState stateForPlacement = this.getStateForPlacement(state, reader, pos, direction);
        return stateForPlacement != null;
    }

    private boolean spreadToFace(IWorld worldIn, BlockPos pos, Direction direction) {
        BlockState state = worldIn.func_180495_p(pos);
        BlockState stateForPlacement = this.getStateForPlacement(state, (IBlockReader)worldIn, pos, direction);
        return stateForPlacement != null && worldIn.func_180501_a(pos, stateForPlacement, 2);
    }

    private boolean canSpreadInto(BlockState state) {
        return state.func_196958_f() || state.func_177230_c() == this || state.func_177230_c() == Blocks.field_150355_j && state.func_204520_s().func_206889_d();
    }

    private static boolean hasFace(BlockState state, Direction direction) {
        BooleanProperty property = MultifaceBlock.getFaceProperty(direction);
        return state.func_235901_b_((Property)property) && (Boolean)state.func_177229_b((Property)property) != false;
    }

    private static boolean canAttachTo(IBlockReader reader, Direction direction, BlockPos pos, BlockState state) {
        return Block.func_208061_a((VoxelShape)state.func_196951_e(reader, pos), (Direction)direction.func_176734_d());
    }

    private boolean isWaterloggable() {
        return this.field_176227_L.func_177623_d().contains(BlockStateProperties.field_208198_y);
    }

    private static BlockState removeFace(BlockState state, BooleanProperty property) {
        BlockState blockState = (BlockState)state.func_206870_a((Property)property, (Comparable)Boolean.valueOf(false));
        if (MultifaceBlock.hasAnyFace(blockState)) {
            return blockState;
        }
        return state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P();
    }

    public static BooleanProperty getFaceProperty(Direction direction) {
        return FACING_TO_PROPERTY_MAP.get(direction);
    }

    private static BlockState getDefaultMultifaceState(StateContainer<Block, BlockState> stateContainer) {
        BlockState state = (BlockState)stateContainer.func_177621_b();
        for (BooleanProperty property : FACING_TO_PROPERTY_MAP.values()) {
            if (!state.func_235901_b_((Property)property)) continue;
            state = (BlockState)state.func_206870_a((Property)property, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    private static VoxelShape calculateMultifaceShape(BlockState state) {
        VoxelShape shape = VoxelShapes.func_197880_a();
        for (Direction direction : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(state, direction)) continue;
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_TO_DIRECTION_MAP.get(direction));
        }
        return shape;
    }

    private static boolean hasAnyFace(BlockState state) {
        return Arrays.stream(DIRECTIONS).anyMatch(direction -> MultifaceBlock.hasFace(state, direction));
    }

    private static boolean hasAnyVacantFace(BlockState state) {
        return Arrays.stream(DIRECTIONS).anyMatch(direction -> !MultifaceBlock.hasFace(state, direction));
    }
}

