/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.AbstractBlock;
import com.blackgear.cavesandcliffs.common.blocks.AbstractCauldronBlock;
import com.blackgear.cavesandcliffs.common.blocks.state.DripstoneThickness;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.CCBParticleTypes;
import com.blackgear.cavesandcliffs.core.registries.api.CCBBlockStateProperties;
import com.blackgear.cavesandcliffs.core.registries.api.CCBSoundTypes;
import com.blackgear.cavesandcliffs.core.registries.api.HeightLimitReader;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.DirectionUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PointedDripstoneBlock
extends AbstractBlock
implements IWaterLoggable {
    public static final DirectionProperty TIP_DIRECTION = CCBBlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<DripstoneThickness> THICKNESS = CCBBlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public PointedDripstoneBlock(AbstractBlock.Properties properties) {
        super(properties, () -> CCBSoundTypes.DRIPSTONE);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)TIP_DIRECTION, (Comparable)Direction.UP)).func_206870_a(THICKNESS, (Comparable)((Object)DripstoneThickness.TIP))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return PointedDripstoneBlock.isValidPointedDripstonePlacement(world, pos, (Direction)state.func_177229_b((Property)TIP_DIRECTION));
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return state;
        }
        Direction tipDirection = (Direction)state.func_177229_b((Property)TIP_DIRECTION);
        if (tipDirection == Direction.DOWN && world.func_205220_G_().func_205361_b(pos, (Object)this)) {
            return state;
        }
        if (direction == tipDirection.func_176734_d() && !this.func_196260_a(state, (IWorldReader)world, pos)) {
            if (tipDirection == Direction.DOWN) {
                this.schedulleStalactiteFallTicks(state, world, pos);
            } else {
                world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
            }
            return state;
        }
        boolean isTipMerged = state.func_177229_b(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness thickness = PointedDripstoneBlock.getThickness((IWorldReader)world, pos, tipDirection, isTipMerged);
        return (BlockState)state.func_206870_a(THICKNESS, (Comparable)((Object)thickness));
    }

    public void func_220066_a(World world, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        if (projectile instanceof TridentEntity && projectile.func_213322_ci().func_72433_c() > 0.6) {
            world.func_175655_b(hit.func_216350_a(), true);
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float distance) {
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177229_b((Property)TIP_DIRECTION) == Direction.UP && blockState.func_177229_b(THICKNESS) == DripstoneThickness.TIP) {
            entity.func_225503_b_(distance + 2.0f, 2.0f);
        } else {
            super.func_180658_a(world, pos, entity, distance);
        }
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        float chance;
        if (PointedDripstoneBlock.canDrip(state) && !((chance = random.nextFloat()) > 0.12f)) {
            PointedDripstoneBlock.getFluidAboveStalactite(world, pos, state).filter(fluid -> chance < 0.02f || PointedDripstoneBlock.canFillCauldron(fluid)).ifPresent(fluid -> PointedDripstoneBlock.spawnDripParticle(world, pos, state, fluid));
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (PointedDripstoneBlock.isStalagmite(state) && !this.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
        } else {
            PointedDripstoneBlock.spawnFallingStalactite(state, world, pos);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        PointedDripstoneBlock.maybeFillCauldron(state, world, pos, random.nextFloat());
        if (random.nextFloat() < 0.011377778f && PointedDripstoneBlock.isStalactiteStartPos(state, (IWorldReader)world, pos)) {
            PointedDripstoneBlock.growStalactiteOrStalagmiteIfPossible(state, world, pos, random);
        }
    }

    @VisibleForTesting
    public static void maybeFillCauldron(BlockState state, ServerWorld world, BlockPos pos, float dripChance) {
        if (!(dripChance > 0.17578125f && dripChance > 0.05859375f || !PointedDripstoneBlock.isStalactiteStartPos(state, (IWorldReader)world, pos))) {
            BlockPos cauldronPos;
            BlockPos tipPos;
            float chance;
            Fluid fluid = PointedDripstoneBlock.getCauldronFillFluidType((World)world, pos);
            if (fluid == Fluids.field_204546_a) {
                chance = 0.17578125f;
            } else {
                if (fluid != Fluids.field_204547_b) {
                    return;
                }
                chance = 0.05859375f;
            }
            if (!(dripChance >= chance) && (tipPos = PointedDripstoneBlock.findTip(state, (IWorld)world, pos, 10, false)) != null && (cauldronPos = PointedDripstoneBlock.findFillableCauldronBelowStalactiteTip((World)world, tipPos, fluid)) != null) {
                PointedDripstoneBlock.spawnDripParticle((World)world, pos, world.func_180495_p(tipPos));
                int distance = tipPos.func_177956_o() - cauldronPos.func_177956_o();
                int fallingTicks = 50 + distance;
                BlockState blockState = world.func_180495_p(cauldronPos);
                world.func_205220_G_().func_205360_a(cauldronPos, (Object)blockState.func_177230_c(), fallingTicks);
            }
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction axis;
        BlockPos pos;
        World world = context.func_195991_k();
        Direction tipDirection = PointedDripstoneBlock.calculateTipDirection((IWorldReader)world, pos = context.func_195995_a(), axis = DirectionUtils.getFacingAxis((Entity)context.func_195999_j(), Direction.Axis.Y).func_176734_d());
        if (tipDirection == null) {
            return null;
        }
        boolean hasSecondaryUse = !context.func_225518_g_();
        DripstoneThickness thickness = PointedDripstoneBlock.getThickness((IWorldReader)world, pos, tipDirection, hasSecondaryUse);
        return thickness == null ? null : (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)TIP_DIRECTION, (Comparable)tipDirection)).func_206870_a(THICKNESS, (Comparable)((Object)thickness))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        DripstoneThickness thickness = (DripstoneThickness)((Object)state.func_177229_b(THICKNESS));
        VoxelShape shape = thickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (thickness == DripstoneThickness.TIP ? (state.func_177229_b((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (thickness == DripstoneThickness.FRUSTUM ? BASE_SHAPE : (thickness == DripstoneThickness.MIDDLE ? FRUSTUM_SHAPE : MIDDLE_SHAPE)));
        Vector3d vec3d = BlockUtils.getOffset(state, world, pos);
        return shape.func_197751_a(vec3d.field_72450_a, 0.0, vec3d.field_72449_c);
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    @Override
    public float getMaxModelOffset() {
        return 0.125f;
    }

    private void schedulleStalactiteFallTicks(BlockState state, IWorld world, BlockPos pos) {
        BlockPos blockPos = PointedDripstoneBlock.findTip(state, world, pos, Integer.MAX_VALUE, true);
        if (blockPos != null) {
            BlockPos.Mutable mutable = blockPos.func_239590_i_();
            while (PointedDripstoneBlock.isStalactite(world.func_180495_p((BlockPos)mutable))) {
                world.func_205220_G_().func_205360_a((BlockPos)mutable, (Object)this, 2);
                mutable.func_189536_c(Direction.UP);
            }
        }
    }

    private static int getStalactiteSize(ServerWorld world, BlockPos pos, int range) {
        int i;
        BlockPos.Mutable mutable = pos.func_239590_i_().func_189536_c(Direction.UP);
        for (i = 1; i < range && PointedDripstoneBlock.isStalactite(world.func_180495_p((BlockPos)mutable)); ++i) {
            mutable.func_189536_c(Direction.UP);
        }
        return i;
    }

    private static void spawnFallingStalactite(BlockState state, ServerWorld world, BlockPos pos) {
        Vector3d vec3d = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        FallingBlockEntity fallingBlockEntity = new FallingBlockEntity((World)world, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, state);
        if (PointedDripstoneBlock.isTip(state, true)) {
            int stalactiteSize = PointedDripstoneBlock.getStalactiteSize(world, pos, 6);
            float fallHurtAmount = 1.0f * (float)stalactiteSize;
            BlockUtils.setHurtEntities(fallingBlockEntity, fallHurtAmount, 40);
        }
        world.func_217376_c((Entity)fallingBlockEntity);
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        BlockState tipState;
        BlockPos tipPos;
        BlockState stalactite;
        BlockState stalagmite;
        Optional<BlockPos> rootBlock = PointedDripstoneBlock.findRootBlock((World)serverWorld, blockPos, blockState, 7);
        if (rootBlock.isPresent() && PointedDripstoneBlock.canGrow(stalagmite = serverWorld.func_180495_p(rootBlock.get()), stalactite = serverWorld.func_180495_p(rootBlock.get().func_177984_a())) && (tipPos = PointedDripstoneBlock.findTip(blockState, (IWorld)serverWorld, blockPos, 7, false)) != null && PointedDripstoneBlock.canDrip(tipState = serverWorld.func_180495_p(tipPos)) && PointedDripstoneBlock.canTipGrow(tipState, serverWorld, tipPos)) {
            if (random.nextBoolean()) {
                PointedDripstoneBlock.grow(serverWorld, tipPos, Direction.DOWN);
            } else {
                PointedDripstoneBlock.growStalagmiteBelow(serverWorld, tipPos);
            }
        }
    }

    private static void growStalagmiteBelow(ServerWorld serverWorld, BlockPos blockPos) {
        BlockPos.Mutable mutable = blockPos.func_239590_i_();
        for (int i = 0; i < 10; ++i) {
            mutable.func_189536_c(Direction.DOWN);
            BlockState blockState = serverWorld.func_180495_p((BlockPos)mutable);
            if (!blockState.func_204520_s().func_206888_e()) {
                return;
            }
            if (PointedDripstoneBlock.isUnmergedTipWithDirection(blockState, Direction.UP) && PointedDripstoneBlock.canTipGrow(blockState, serverWorld, (BlockPos)mutable)) {
                PointedDripstoneBlock.grow(serverWorld, (BlockPos)mutable, Direction.UP);
                return;
            }
            if (!PointedDripstoneBlock.isValidPointedDripstonePlacement((IWorldReader)serverWorld, (BlockPos)mutable, Direction.UP) || serverWorld.func_204610_c(mutable.func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            PointedDripstoneBlock.grow(serverWorld, mutable.func_177977_b(), Direction.UP);
            return;
        }
    }

    private static void grow(ServerWorld serverWorld, BlockPos blockPos, Direction direction) {
        BlockPos offset = blockPos.func_177972_a(direction);
        BlockState state = serverWorld.func_180495_p(offset);
        if (PointedDripstoneBlock.isUnmergedTipWithDirection(state, direction.func_176734_d())) {
            PointedDripstoneBlock.createMergedTips(state, (IWorld)serverWorld, offset);
        } else if (state.func_196958_f() || state.func_203425_a(Blocks.field_150355_j)) {
            PointedDripstoneBlock.createDripstone((IWorld)serverWorld, offset, direction, DripstoneThickness.TIP);
        }
    }

    private static void createDripstone(IWorld IWorld2, BlockPos blockPos, Direction direction, DripstoneThickness thickness) {
        BlockState blockState = (BlockState)((BlockState)((BlockState)((Block)CCBBlocks.POINTED_DRIPSTONE.get()).func_176223_P().func_206870_a((Property)TIP_DIRECTION, (Comparable)direction)).func_206870_a(THICKNESS, (Comparable)((Object)thickness))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(IWorld2.func_204610_c(blockPos).func_206886_c() == Fluids.field_204546_a));
        IWorld2.func_180501_a(blockPos, blockState, 3);
    }

    private static void createMergedTips(BlockState blockState, IWorld IWorld2, BlockPos blockPos) {
        BlockPos stalagmite;
        BlockPos stalactite;
        if (blockState.func_177229_b((Property)TIP_DIRECTION) == Direction.UP) {
            stalactite = blockPos;
            stalagmite = blockPos.func_177984_a();
        } else {
            stalagmite = blockPos;
            stalactite = blockPos.func_177977_b();
        }
        PointedDripstoneBlock.createDripstone(IWorld2, stalagmite, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        PointedDripstoneBlock.createDripstone(IWorld2, stalactite, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    public static void spawnDripParticle(World world, BlockPos pos, BlockState state) {
        PointedDripstoneBlock.getFluidAboveStalactite(world, pos, state).ifPresent(fluid -> PointedDripstoneBlock.spawnDripParticle(world, pos, state, fluid));
    }

    private static void spawnDripParticle(World world, BlockPos pos, BlockState state, Fluid fluid) {
        Vector3d offset = state.func_191059_e((IBlockReader)world, pos);
        double x = (double)pos.func_177958_n() + 0.5 + offset.field_72450_a;
        double y = (double)((float)(pos.func_177956_o() + 1) - 0.6875f) - 0.0625;
        double z = (double)pos.func_177952_p() + 0.5 + offset.field_72449_c;
        Fluid dripFluid = PointedDripstoneBlock.getCauldronFillFluidType(world, fluid);
        IParticleData dripParticle = dripFluid.func_207185_a((ITag)FluidTags.field_206960_b) ? (IParticleData)CCBParticleTypes.DRIPPING_DRIPSTONE_LAVA.get() : (IParticleData)CCBParticleTypes.DRIPPING_DRIPSTONE_WATER.get();
        world.func_195594_a(dripParticle, x, y, z, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos findTip(BlockState state, IWorld world, BlockPos pos, int range, boolean shouldMerge) {
        if (PointedDripstoneBlock.isTip(state, shouldMerge)) {
            return pos;
        }
        Direction direction = (Direction)state.func_177229_b((Property)TIP_DIRECTION);
        Predicate<BlockState> predicate = blockState -> blockState.func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get()) && blockState.func_177229_b((Property)TIP_DIRECTION) == direction;
        return PointedDripstoneBlock.findBlockVertical(world, pos, direction.func_176743_c(), predicate, blockState -> PointedDripstoneBlock.isTip(blockState, shouldMerge), range).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(IWorldReader world, BlockPos pos, Direction direction) {
        Direction tipDirection;
        if (PointedDripstoneBlock.isValidPointedDripstonePlacement(world, pos, direction)) {
            tipDirection = direction;
        } else {
            if (!PointedDripstoneBlock.isValidPointedDripstonePlacement(world, pos, direction.func_176734_d())) {
                return null;
            }
            tipDirection = direction.func_176734_d();
        }
        return tipDirection;
    }

    private static DripstoneThickness getThickness(IWorldReader world, BlockPos pos, Direction direction, boolean tryMerge) {
        Direction tipDirection = direction.func_176734_d();
        BlockState state = world.func_180495_p(pos.func_177972_a(direction));
        if (PointedDripstoneBlock.isPointedDripstoneFacingDirection(state, tipDirection)) {
            return !tryMerge && state.func_177229_b(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!PointedDripstoneBlock.isPointedDripstoneFacingDirection(state, direction)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness thickness = (DripstoneThickness)((Object)state.func_177229_b(THICKNESS));
        if (thickness != DripstoneThickness.TIP && thickness != DripstoneThickness.TIP_MERGE) {
            BlockState tipState = world.func_180495_p(pos.func_177972_a(tipDirection));
            return !PointedDripstoneBlock.isPointedDripstoneFacingDirection(tipState, direction) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return PointedDripstoneBlock.isStalactite(state) && state.func_177229_b(THICKNESS) == DripstoneThickness.TIP && (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos) {
        Direction direction = (Direction)blockState.func_177229_b((Property)TIP_DIRECTION);
        BlockPos pos = blockPos.func_177972_a(direction);
        BlockState state = serverWorld.func_180495_p(pos);
        if (!state.func_204520_s().func_206888_e()) {
            return false;
        }
        return state.func_196958_f() || PointedDripstoneBlock.isUnmergedTipWithDirection(state, direction.func_176734_d());
    }

    private static Optional<BlockPos> findRootBlock(World world, BlockPos pos, BlockState state, int range) {
        Direction direction = (Direction)state.func_177229_b((Property)TIP_DIRECTION);
        Predicate<BlockState> predicate = blockState -> blockState.func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get()) && blockState.func_177229_b((Property)TIP_DIRECTION) == direction;
        return PointedDripstoneBlock.findBlockVertical((IWorld)world, pos, direction.func_176734_d().func_176743_c(), predicate, blockState -> !blockState.func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get()), range);
    }

    private static boolean isValidPointedDripstonePlacement(IWorldReader world, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.func_177972_a(direction.func_176734_d());
        BlockState blockState = world.func_180495_p(blockPos);
        return blockState.func_224755_d((IBlockReader)world, blockPos, direction) || PointedDripstoneBlock.isPointedDripstoneFacingDirection(blockState, direction);
    }

    private static boolean isTip(BlockState state, boolean shouldMerge) {
        if (!state.func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get())) {
            return false;
        }
        DripstoneThickness thickness = (DripstoneThickness)((Object)state.func_177229_b(THICKNESS));
        return thickness == DripstoneThickness.TIP || shouldMerge && thickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState blockState, Direction direction) {
        return PointedDripstoneBlock.isTip(blockState, false) && blockState.func_177229_b((Property)TIP_DIRECTION) == direction;
    }

    private static boolean isStalactite(BlockState state) {
        return PointedDripstoneBlock.isPointedDripstoneFacingDirection(state, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState blockState) {
        return PointedDripstoneBlock.isPointedDripstoneFacingDirection(blockState, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState state, IWorldReader world, BlockPos pos) {
        return PointedDripstoneBlock.isStalactite(state) && !world.func_180495_p(pos.func_177984_a()).func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get());
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }

    private static boolean isPointedDripstoneFacingDirection(BlockState state, Direction direction) {
        return state.func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get()) && state.func_177229_b((Property)TIP_DIRECTION) == direction;
    }

    @Nullable
    private static BlockPos findFillableCauldronBelowStalactiteTip(World world, BlockPos pos, Fluid fluid) {
        Predicate<BlockState> predicate = state -> state.func_177230_c() instanceof AbstractCauldronBlock && ((AbstractCauldronBlock)state.func_177230_c()).canReceiveStalactiteDrip(fluid);
        return PointedDripstoneBlock.findBlockVertical((IWorld)world, pos, Direction.DOWN.func_176743_c(), AbstractBlock.AbstractBlockState::func_196958_f, predicate, 10).orElse(null);
    }

    @Nullable
    public static BlockPos findStalactiteTipAboveCauldron(World world, BlockPos pos) {
        return PointedDripstoneBlock.findBlockVertical((IWorld)world, pos, Direction.UP.func_176743_c(), AbstractBlock.AbstractBlockState::func_196958_f, PointedDripstoneBlock::canDrip, 10).orElse(null);
    }

    public static Fluid getCauldronFillFluidType(World world, BlockPos pos) {
        return PointedDripstoneBlock.getFluidAboveStalactite(world, pos, world.func_180495_p(pos)).filter(PointedDripstoneBlock::canFillCauldron).orElse(Fluids.field_204541_a);
    }

    private static Optional<Fluid> getFluidAboveStalactite(World world, BlockPos pos, BlockState state) {
        return !PointedDripstoneBlock.isStalactite(state) ? Optional.empty() : PointedDripstoneBlock.findRootBlock(world, pos, state, 10).map(posx -> world.func_204610_c(posx.func_177984_a()).func_206886_c());
    }

    private static boolean canFillCauldron(Fluid fluid) {
        return fluid == Fluids.field_204547_b || fluid == Fluids.field_204546_a;
    }

    private static boolean canGrow(BlockState baseState, BlockState fluidState) {
        return baseState.func_203425_a((Block)CCBBlocks.DRIPSTONE_BLOCK.get()) && fluidState.func_203425_a(Blocks.field_150355_j) && fluidState.func_204520_s().func_206889_d();
    }

    private static Fluid getCauldronFillFluidType(World world, Fluid fluid) {
        if (fluid.func_207187_a(Fluids.field_204541_a)) {
            return world.func_230315_m_().func_236040_e_() ? Fluids.field_204547_b : Fluids.field_204546_a;
        }
        return fluid;
    }

    private static Optional<BlockPos> findBlockVertical(IWorld world, BlockPos pos, Direction.AxisDirection direction, Predicate<BlockState> continuePredicate, Predicate<BlockState> stopPredicate, int range) {
        Direction axisDirection = Direction.func_181076_a((Direction.AxisDirection)direction, (Direction.Axis)Direction.Axis.Y);
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (int i = 0; i < range; ++i) {
            mutable.func_189536_c(axisDirection);
            BlockState blockState = world.func_180495_p((BlockPos)mutable);
            if (stopPredicate.test(blockState)) {
                return Optional.of(mutable);
            }
            if (!HeightLimitReader.isOutOfHeightLimit(mutable.func_177956_o()) && continuePredicate.test(blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }
}

