/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entities.passive.ai.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.EntityPredicates;
import net.minecraft.world.server.ServerWorld;

public class StopAttackingIfTargetInvalidTask<E extends MobEntity>
extends Task<E> {
    private final Predicate<LivingEntity> stopAttackingWhen;
    private final Consumer<E> onTargetErased;

    public StopAttackingIfTargetInvalidTask(Predicate<LivingEntity> stopAttackingWhen, Consumer<E> onTargetErased) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_223021_x, (Object)MemoryModuleStatus.REGISTERED));
        this.stopAttackingWhen = stopAttackingWhen;
        this.onTargetErased = onTargetErased;
    }

    public StopAttackingIfTargetInvalidTask(Predicate<LivingEntity> stopAttackingWhen) {
        this(stopAttackingWhen, onTargetErased -> {});
    }

    public StopAttackingIfTargetInvalidTask(Consumer<E> onTargetErased) {
        this(stopAttackingWhen -> false, onTargetErased);
    }

    public StopAttackingIfTargetInvalidTask() {
        this(stopAttackingWhen -> false, onTargetErased -> {});
    }

    protected void startExecuting(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        if (StopAttackingIfTargetInvalidTask.isTiredOfTryingToReachTarget(entityIn)) {
            this.clearAttackTarget(entityIn);
        } else if (this.isCurrentTargetDeadOrRemoved(entityIn)) {
            this.clearAttackTarget(entityIn);
        } else if (this.isCurrentTargetInDifferentWorld(entityIn)) {
            this.clearAttackTarget(entityIn);
        } else if (!EntityPredicates.field_180132_d.test(this.getAttackTarget(entityIn))) {
            this.clearAttackTarget(entityIn);
        } else if (this.stopAttackingWhen.test(this.getAttackTarget(entityIn))) {
            this.clearAttackTarget(entityIn);
        }
    }

    private boolean isCurrentTargetInDifferentWorld(E entity) {
        return this.getAttackTarget(entity).field_70170_p != ((MobEntity)entity).field_70170_p;
    }

    private LivingEntity getAttackTarget(E entity) {
        return (LivingEntity)entity.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_).get();
    }

    private static <E extends LivingEntity> boolean isTiredOfTryingToReachTarget(E entity) {
        Optional ticks = entity.func_213375_cj().func_218207_c(MemoryModuleType.field_223021_x);
        return ticks.isPresent() && entity.field_70170_p.func_82737_E() - (Long)ticks.get() > 200L;
    }

    private boolean isCurrentTargetDeadOrRemoved(E entity) {
        Optional attackTarget = entity.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_);
        return attackTarget.isPresent() && !((LivingEntity)attackTarget.get()).func_70089_S();
    }

    protected void clearAttackTarget(E entity) {
        this.onTargetErased.accept(entity);
        entity.func_213375_cj().func_218189_b(MemoryModuleType.field_234103_o_);
    }
}

