/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entities.passive.goat;

import com.blackgear.cavesandcliffs.common.entities.CCBPose;
import com.blackgear.cavesandcliffs.common.entities.passive.goat.GoatTasks;
import com.blackgear.cavesandcliffs.core.registries.CCBAI;
import com.blackgear.cavesandcliffs.core.registries.CCBEntityTypes;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.blackgear.cavesandcliffs.core.registries.other.utils.ItemUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GoatEntity
extends AnimalEntity {
    public static final EntitySize LONG_JUMPING_SIZE = EntitySize.func_220314_b((float)0.9f, (float)1.3f).func_220313_a(0.7f);
    protected static final ImmutableList<SensorType<? extends Sensor<? super GoatEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.field_220998_b, (Object)SensorType.field_220999_c, (Object)SensorType.field_234129_b_, (Object)SensorType.field_221002_f, (Object)CCBAI.GOAT_TEMPTATIONS.get());
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleType.field_223021_x, (Object)MemoryModuleType.field_220954_o, (Object)MemoryModuleType.field_234097_ae_, (Object)MemoryModuleType.field_220953_n, (Object)CCBAI.LONG_JUMP_COOLDOWN_TICKS.get(), (Object)CCBAI.LONG_JUMP_MID_JUMP.get(), (Object)CCBAI.TEMPTING_PLAYER.get(), (Object)CCBAI.TEMPTATION_COOLDOWN_TICKS.get(), (Object)CCBAI.IS_TEMPTED.get(), (Object[])new MemoryModuleType[]{(MemoryModuleType)CCBAI.RAM_COOLDOWN_TICKS.get(), (MemoryModuleType)CCBAI.RAM_TARGET.get()});
    private static final DataParameter<Boolean> IS_SCREAMING_GOAT = EntityDataManager.func_187226_a(GoatEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean isLoweringHead;
    private int lowerHeadTick;

    public GoatEntity(EntityType<? extends GoatEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_70661_as().func_212239_d(true);
    }

    protected Brain.BrainCodec<GoatEntity> func_230289_cH_() {
        return Brain.func_233705_a_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamicIn) {
        return GoatTasks.makeBrain((Brain<GoatEntity>)this.func_230289_cH_().func_233748_a_(dynamicIn));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233819_b_, 7.0);
    }

    protected int func_225508_e_(float distance, float damageMultiplier) {
        return super.func_225508_e_(distance, damageMultiplier) - 10;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_SCREAM.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_IDLE.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_SCREAM_HURT.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return this.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_SCREAM_DEATH.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a((SoundEvent)CCBSoundEvents.ENTITY_GOAT_STEP.get(), 0.15f, 1.0f);
    }

    protected SoundEvent getMilkingSound() {
        return this.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_SCREAM_MILK.get() : SoundEvents.field_187564_an;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld worldIn, AgeableEntity entityIn) {
        GoatEntity goat = (GoatEntity)entityIn;
        GoatEntity goatEntity = (GoatEntity)((EntityType)CCBEntityTypes.GOAT.get()).func_200721_a((World)worldIn);
        if (goat != null && goatEntity.isScreaming()) {
            goatEntity.setScreaming(true);
        }
        return goatEntity;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? sizeIn.field_220316_b * 0.95f : 1.3f;
    }

    public Brain<GoatEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("goatBrain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("goatActivityUpdate");
        GoatTasks.updateActivity(this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        super.func_70619_bc();
    }

    public int func_184649_cE() {
        return 15;
    }

    public SoundEvent func_213353_d(ItemStack itemStackIn) {
        return this.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_SCREAM.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_IDLE.get();
    }

    public ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (heldItem.func_77973_b().equals(Items.field_151133_ar) && !this.func_70631_g_()) {
            playerIn.func_184185_a(this.getMilkingSound(), 1.0f, 1.0f);
            ItemStack milkBucket = ItemUtils.createFilledResult(heldItem, playerIn, Items.field_151117_aB.func_190903_i());
            playerIn.func_184611_a(hand, milkBucket);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        ActionResultType actionResultType = super.func_230254_b_(playerIn, hand);
        if (actionResultType.func_226247_b_() && this.func_70877_b(heldItem)) {
            this.field_70170_p.func_217384_a(null, (Entity)this, this.func_213353_d(heldItem), SoundCategory.NEUTRAL, 1.0f, MathUtils.randomBetween(this.field_70170_p.field_73012_v, 0.8f, 1.2f));
        }
        return actionResultType;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        GoatTasks.initMemories(this);
        this.setScreaming(worldIn.func_201674_k().nextDouble() < 0.02);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_213387_K() {
        super.func_213387_K();
        DebugPacketSender.func_218798_a((LivingEntity)this);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return poseIn == CCBPose.LONG_JUMPING ? LONG_JUMPING_SIZE.func_220313_a(this.func_213355_cm()) : super.func_213305_a(poseIn);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsScreamingGoat", this.isScreaming());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setScreaming(compound.func_74767_n("IsScreamingGoat"));
    }

    public void func_70103_a(byte id) {
        if (id == 58) {
            this.isLoweringHead = true;
        } else if (id == 59) {
            this.isLoweringHead = false;
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70636_d() {
        this.lowerHeadTick = this.isLoweringHead ? ++this.lowerHeadTick : (this.lowerHeadTick -= 2);
        this.lowerHeadTick = MathHelper.func_76125_a((int)this.lowerHeadTick, (int)0, (int)20);
        super.func_70636_d();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_SCREAMING_GOAT, (Object)false);
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SCREAMING_GOAT);
    }

    public void setScreaming(boolean shouldScream) {
        this.field_70180_af.func_187227_b(IS_SCREAMING_GOAT, (Object)shouldScream);
    }

    public float getRammingXHeadRot() {
        return (float)this.lowerHeadTick / 20.0f * 30.0f * ((float)Math.PI / 180);
    }
}

