/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen;

import com.blackgear.cavesandcliffs.common.world.gen.MaxMinNoiseMixer;
import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.NoiseUtils;
import java.util.Random;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MathHelper;

public class Cavifier {
    private final int minCellY;
    private final MaxMinNoiseMixer layerNoiseSource;
    private final MaxMinNoiseMixer pillarNoiseSource;
    private final MaxMinNoiseMixer pillarRarenessModulator;
    private final MaxMinNoiseMixer pillarThicknessModulator;
    private final MaxMinNoiseMixer spaghetti2dNoiseSource;
    private final MaxMinNoiseMixer spaghetti2dElevationModulator;
    private final MaxMinNoiseMixer spaghetti2dRarityModulator;
    private final MaxMinNoiseMixer spaghetti2dThicknessModulator;
    private final MaxMinNoiseMixer spaghetti3dNoiseSource1;
    private final MaxMinNoiseMixer spaghetti3dNoiseSource2;
    private final MaxMinNoiseMixer spaghetti3dRarityModulator;
    private final MaxMinNoiseMixer spaghetti3dThicknessModulator;
    private final MaxMinNoiseMixer spaghettiRoughnessNoise;
    private final MaxMinNoiseMixer spaghettiRoughnessModulator;
    private final MaxMinNoiseMixer caveEntranceNoiseSource;
    private final MaxMinNoiseMixer cheeseNoiseSource;

    public Cavifier(Random rand, int height) {
        this.minCellY = height;
        this.pillarNoiseSource = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -7, 1.0);
        this.pillarRarenessModulator = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -8, 1.0);
        this.pillarThicknessModulator = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -8, 1.0);
        this.spaghetti2dNoiseSource = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -7, 1.0);
        this.spaghetti2dElevationModulator = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -8, 1.0);
        this.spaghetti2dRarityModulator = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -11, 1.0);
        this.spaghetti2dThicknessModulator = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -11, 1.0);
        this.spaghetti3dNoiseSource1 = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -7, 1.0);
        this.spaghetti3dNoiseSource2 = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -7, 1.0);
        this.spaghetti3dRarityModulator = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -11, 1.0);
        this.spaghetti3dThicknessModulator = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -8, 1.0);
        this.spaghettiRoughnessNoise = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -5, 1.0);
        this.spaghettiRoughnessModulator = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -8, 1.0);
        this.caveEntranceNoiseSource = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -8, 1.0);
        this.layerNoiseSource = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -8, 1.0);
        this.cheeseNoiseSource = MaxMinNoiseMixer.create(new SharedSeedRandom(rand.nextLong()), -8, 0.5);
    }

    public double cavify(int x, int y, int z, double height) {
        boolean inRange = height < 170.0;
        double roughness = this.spaghettiRoughness(x, y, z);
        double spaghetti3d = this.getSpaghetti3d(x, y, z);
        if (inRange) {
            return Math.max(height, (spaghetti3d + roughness) * 128.0 * 5.0);
        }
        double cheeseNoise = this.cheeseNoiseSource.getValue(x, (double)y / 1.5, z);
        double clampedNoise = MathHelper.func_151237_a((double)(cheeseNoise + 0.25), (double)-1.0, (double)1.0);
        double slide = (float)(30 - y) / 8.0f;
        double clampedLerpNoise = clampedNoise + MathHelper.func_151238_b((double)0.5, (double)0.0, (double)slide);
        double layerizedCaverns = this.getLayerizedCaverns(x, y, z);
        double spaghetti2d = this.getSpaghetti2d(x, y, z);
        double caveNoiseValue = clampedLerpNoise + layerizedCaverns;
        double minCaveNoise = Math.min(caveNoiseValue, Math.min(spaghetti3d, spaghetti2d) + roughness);
        double maxCaveNoise = Math.max(minCaveNoise, this.getPillars(x, y, z));
        return 128.0 * MathHelper.func_151238_b((double)maxCaveNoise, (double)-1.0, (double)1.0);
    }

    private double addEntrances(double height, int x, int y, int z) {
        double entranceNoise = this.caveEntranceNoiseSource.getValue(x * 2, y, z * 2);
        entranceNoise = NoiseUtils.biasTowardsExtreme(entranceNoise, 1.0);
        double depth = (double)y / 40.0;
        entranceNoise += MathHelper.func_151238_b((double)0.5, (double)height, (double)depth);
        entranceNoise = 4.0 * entranceNoise + 3.0;
        return Math.min(height, entranceNoise);
    }

    private double getPillars(int x, int y, int z) {
        double rareness = NoiseUtils.sampleNoiseAndMapToRange(this.pillarRarenessModulator, x, y, z, 0.0, 2.0);
        double thickness = NoiseUtils.sampleNoiseAndMapToRange(this.pillarThicknessModulator, x, y, z, 0.0, 1.1);
        thickness = Math.pow(thickness, 3.0);
        double noise = this.pillarNoiseSource.getValue((double)x * 25.0, (double)y * 0.3, (double)z * 25.0);
        return (noise = thickness * (noise * 2.0 - rareness)) > 0.03 ? noise : Double.NEGATIVE_INFINITY;
    }

    private double getLayerizedCaverns(int x, int y, int z) {
        double noise = this.layerNoiseSource.getValue(x, y * 8, z);
        return MathUtils.square(noise) * 4.0;
    }

    private double getSpaghetti3d(int x, int y, int z) {
        double rarityModulator = this.spaghetti3dRarityModulator.getValue(x * 2, y, z * 2);
        double spaghetti3dRarity = QuantizedSpaghettiRarity.getSpaghettiRarity3D(rarityModulator);
        double thicknessRange = NoiseUtils.sampleNoiseAndMapToRange(this.spaghetti3dThicknessModulator, x, y, z, 0.065, 0.088);
        double firstNoiseRarity = Cavifier.sampleWithRarity(this.spaghetti3dNoiseSource1, x, y, z, spaghetti3dRarity);
        double firstNoise = Math.abs(spaghetti3dRarity * firstNoiseRarity) - thicknessRange;
        double secondNoiseRarity = Cavifier.sampleWithRarity(this.spaghetti3dNoiseSource2, x, y, z, spaghetti3dRarity);
        double secondNoise = Math.abs(spaghetti3dRarity * secondNoiseRarity) - thicknessRange;
        return Cavifier.clampToUnit(Math.max(firstNoise, secondNoise));
    }

    private double getSpaghetti2d(int x, int y, int z) {
        double rarityModulator = this.spaghetti2dRarityModulator.getValue(x * 2, y, z * 2);
        double spaghetti2dRarity = QuantizedSpaghettiRarity.getSpaghettiRarity2D(rarityModulator);
        double thicknessRange = NoiseUtils.sampleNoiseAndMapToRange(this.spaghetti2dThicknessModulator, x * 2, y, z * 2, 0.6, 1.3);
        double rarity = Cavifier.sampleWithRarity(this.spaghetti2dNoiseSource, x, y, z, rarityModulator);
        double thickness = Math.abs(spaghetti2dRarity * rarity) - 0.083 * thicknessRange;
        double elevationRange = NoiseUtils.sampleNoiseAndMapToRange(this.spaghetti2dElevationModulator, x, 0.0, z, this.minCellY, 8.0);
        double elevation = Math.abs(elevationRange - (double)y / 8.0) - thicknessRange;
        elevation = elevation * elevation * elevation;
        return Cavifier.clampToUnit(Math.max(elevation, thickness));
    }

    private double spaghettiRoughness(int x, int y, int z) {
        double range = NoiseUtils.sampleNoiseAndMapToRange(this.spaghettiRoughnessModulator, x, y, z, 0.0, 0.1);
        return (0.4 - Math.abs(this.spaghettiRoughnessNoise.getValue(x, y, z))) * range;
    }

    private static double clampToUnit(double value) {
        return MathHelper.func_151237_a((double)value, (double)-1.0, (double)1.0);
    }

    private static double sampleWithRarity(MaxMinNoiseMixer noise, double x, double y, double z, double rarity) {
        return noise.getValue(x / rarity, y / rarity, z / rarity);
    }

    static final class QuantizedSpaghettiRarity {
        private QuantizedSpaghettiRarity() {
        }

        private static double getSpaghettiRarity2D(double rarity) {
            if (rarity < -0.75) {
                return 0.5;
            }
            if (rarity < -0.5) {
                return 0.75;
            }
            if (rarity < 0.5) {
                return 1.0;
            }
            return rarity < 0.75 ? 2.0 : 3.0;
        }

        private static double getSpaghettiRarity3D(double rarity) {
            if (rarity < -0.5) {
                return 0.75;
            }
            if (rarity < 0.0) {
                return 1.0;
            }
            return rarity < 0.5 ? 1.5 : 2.0;
        }
    }
}

