/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen;

import com.blackgear.bgcore.core.BGConfig;
import com.blackgear.bgcore.core.registries.BGBiomes;
import com.blackgear.cavesandcliffs.common.world.gen.VanillaBiomeFeatures;
import com.blackgear.cavesandcliffs.core.registries.CCBBiomes;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class GlobalBiomeFeatures {
    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.NETHER || event.getCategory() == Biome.Category.THEEND) {
            return;
        }
        if (event.getName() == null) {
            return;
        }
        ResourceLocation biomeID = event.getName();
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(biomeID);
        RegistryKey VanillaBiome = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biomeID);
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        MobSpawnInfoBuilder spawns = event.getSpawns();
        if (biome == BGBiomes.DEFAULT_CAVE.get()) {
            this.generateDefaultCaveFeatures((BiomeGenerationSettings.Builder)generation, (MobSpawnInfo.Builder)spawns);
        }
        if (biome == CCBBiomes.DRIPSTONE_CAVES.get()) {
            this.generateDripstoneCaveFeatures((BiomeGenerationSettings.Builder)generation, (MobSpawnInfo.Builder)spawns);
        }
        if (biome == CCBBiomes.LUSH_CAVES.get()) {
            this.generateLushCaveFeatures((BiomeGenerationSettings.Builder)generation, (MobSpawnInfo.Builder)spawns);
        }
        if (VanillaBiome == Biomes.field_76770_e) {
            VanillaBiomeFeatures.addMountainSpawns((MobSpawnInfo.Builder)spawns);
        }
        if (event.getCategory() == Biome.Category.EXTREME_HILLS) {
            VanillaBiomeFeatures.addDeepslateEmerald((BiomeGenerationSettings.Builder)generation);
        }
        if (!((Boolean)BGConfig.caveBiomeSpawning.get()).booleanValue()) {
            this.generateCaveFeatures((BiomeGenerationSettings.Builder)generation);
        }
    }

    private void generateCaveFeatures(BiomeGenerationSettings.Builder generation) {
        VanillaBiomeFeatures.addDefaultCrystalFormations(generation);
        VanillaBiomeFeatures.addDefaultUndergroundVariety(generation);
        VanillaBiomeFeatures.generateDeepslate(generation);
        VanillaBiomeFeatures.addCopperOre(generation);
    }

    private void generateDefaultCaveFeatures(BiomeGenerationSettings.Builder generation, MobSpawnInfo.Builder spawns) {
        VanillaBiomeFeatures.addDefaultCrystalFormations(generation);
        VanillaBiomeFeatures.addDefaultUndergroundVariety(generation);
        VanillaBiomeFeatures.generateDeepslate(generation);
        VanillaBiomeFeatures.addCopperOre(generation);
        VanillaBiomeFeatures.addCaveWaterSpawns(spawns);
    }

    private void generateDripstoneCaveFeatures(BiomeGenerationSettings.Builder generation, MobSpawnInfo.Builder spawns) {
        VanillaBiomeFeatures.addDefaultCrystalFormations(generation);
        VanillaBiomeFeatures.addDefaultUndergroundVariety(generation);
        VanillaBiomeFeatures.addDripstone(generation);
        VanillaBiomeFeatures.generateDeepslate(generation);
        VanillaBiomeFeatures.addCopperOre(generation);
        VanillaBiomeFeatures.addCaveWaterSpawns(spawns);
        VanillaBiomeFeatures.addCommonSpawns(spawns);
    }

    private void generateLushCaveFeatures(BiomeGenerationSettings.Builder generation, MobSpawnInfo.Builder spawns) {
        VanillaBiomeFeatures.addDefaultCrystalFormations(generation);
        VanillaBiomeFeatures.addLushCavesSpecialOres(generation);
        VanillaBiomeFeatures.addLushCavesVegetationFeatures(generation);
        VanillaBiomeFeatures.addDefaultUndergroundVariety(generation);
        VanillaBiomeFeatures.generateDeepslate(generation);
        VanillaBiomeFeatures.addCopperOre(generation);
        VanillaBiomeFeatures.addCaveWaterSpawns(spawns);
        VanillaBiomeFeatures.addCommonSpawns(spawns);
    }
}

