/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.features;

import com.blackgear.cavesandcliffs.common.blocks.GlowLichenBlock;
import com.blackgear.cavesandcliffs.common.world.gen.features.config.GlowLichenConfig;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockPosUtils;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class GlowLichenFeature
extends Feature<GlowLichenConfig> {
    public GlowLichenFeature(Codec<GlowLichenConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, GlowLichenConfig config) {
        if (!GlowLichenFeature.isAirOrWater(worldIn.func_180495_p(pos))) {
            return false;
        }
        List<Direction> directions = GlowLichenFeature.getShuffledDirections(config, rand);
        if (GlowLichenFeature.placeGlowLichenIfPossible((IWorld)worldIn, pos, worldIn.func_180495_p(pos), config, rand, directions)) {
            return true;
        }
        BlockPos.Mutable blockPos = pos.func_239590_i_();
        block0: for (Direction direction : directions) {
            blockPos.func_189533_g((Vector3i)pos);
            List<Direction> validDirections = GlowLichenFeature.getShuffledDirectionsExcept(config, rand, direction.func_176734_d());
            for (int range = 0; range < config.searchRange; ++range) {
                BlockPosUtils.setAndOffset(blockPos, (Vector3i)pos, direction);
                BlockState state = worldIn.func_180495_p((BlockPos)blockPos);
                if (!GlowLichenFeature.isAirOrWater(state) && !state.func_177230_c().equals(CCBBlocks.GLOW_LICHEN.get())) continue block0;
                if (!GlowLichenFeature.placeGlowLichenIfPossible((IWorld)worldIn, (BlockPos)blockPos, state, config, rand, validDirections)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean placeGlowLichenIfPossible(IWorld worldIn, BlockPos pos, BlockState state, GlowLichenConfig config, Random rand, List<Direction> validDirections) {
        Direction direction;
        BlockState blockState;
        BlockPos.Mutable blockPos = pos.func_239590_i_();
        Iterator<Direction> directionIterator = validDirections.iterator();
        do {
            if (directionIterator.hasNext()) continue;
            return false;
        } while (!config.canBePlacedOn((blockState = worldIn.func_180495_p((BlockPos)BlockPosUtils.setAndOffset(blockPos, (Vector3i)pos, direction = directionIterator.next()))).func_177230_c()));
        GlowLichenBlock glowLichenBlock = (GlowLichenBlock)CCBBlocks.GLOW_LICHEN.get();
        BlockState glowLichenPlacementState = glowLichenBlock.getStateForPlacement(state, (IBlockReader)worldIn, pos, direction);
        if (glowLichenPlacementState == null) {
            return false;
        }
        worldIn.func_180501_a(pos, glowLichenPlacementState, 3);
        if (rand.nextFloat() < config.chanceOfSpreading) {
            glowLichenBlock.spreadFromFaceTowardRandomDirection(glowLichenPlacementState, worldIn, pos, direction, rand);
        }
        return true;
    }

    public static List<Direction> getShuffledDirections(GlowLichenConfig config, Random rand) {
        ArrayList directions = Lists.newArrayList(config.validDirections);
        Collections.shuffle(directions, rand);
        return directions;
    }

    public static List<Direction> getShuffledDirectionsExcept(GlowLichenConfig config, Random rand, Direction invalidDirection) {
        List<Direction> directions = config.validDirections.stream().filter(direction -> direction != invalidDirection).collect(Collectors.toList());
        Collections.shuffle(directions, rand);
        return directions;
    }

    private static boolean isAirOrWater(BlockState state) {
        return state.func_196958_f() || state.func_177230_c() == Blocks.field_150355_j;
    }
}

