/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.features;

import com.blackgear.cavesandcliffs.common.utils.math.FloatProvider;
import com.blackgear.cavesandcliffs.common.world.gen.Column;
import com.blackgear.cavesandcliffs.common.world.gen.features.DripstoneUtils;
import com.blackgear.cavesandcliffs.common.world.gen.features.config.LargeDripstoneConfig;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockPosUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;

public class LargeDripstoneFeature
extends Feature<LargeDripstoneConfig> {
    public LargeDripstoneFeature(Codec<LargeDripstoneConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, LargeDripstoneConfig config) {
        if (!DripstoneUtils.isEmptyOrWater((IWorld)worldIn, pos)) {
            return false;
        }
        Optional<Column> column = Column.scan((IWorldGenerationReader)worldIn, pos, config.floorToCeilingSearchRange, DripstoneUtils::isEmptyOrWater, DripstoneUtils::isDripstoneBaseOrLava);
        if (column.isPresent() && column.get() instanceof Column.Range) {
            Column.Range range = (Column.Range)column.get();
            if (range.height() < 4) {
                return false;
            }
            int height = (int)((float)range.height() * config.maxColumnRadiusToCaveHeightRatio);
            int distance = MathHelper.func_76125_a((int)height, (int)config.columnRadius.getMinValue(), (int)config.columnRadius.getMaxValue());
            int radius = MathUtils.randomBetweenInclusive(rand, config.columnRadius.getMinValue(), distance);
            LargeDripstone ceilingDripstone = LargeDripstoneFeature.makeDripstone(BlockPosUtils.atY(pos, range.ceiling() - 1), false, rand, radius, config.stalactiteBluntness, config.heightScale);
            LargeDripstone floorDripstone = LargeDripstoneFeature.makeDripstone(BlockPosUtils.atY(pos, range.floor() + 1), true, rand, radius, config.stalagmiteBluntness, config.heightScale);
            WindOffsetter windOffsetter = ceilingDripstone.isSuitableForWind(config) && floorDripstone.isSuitableForWind(config) ? new WindOffsetter(pos.func_177956_o(), rand, config.windSpeed) : WindOffsetter.noWind();
            boolean shouldPlaceOnCeiling = ceilingDripstone.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary((IWorld)worldIn, windOffsetter);
            boolean shouldPlaceOnFloor = floorDripstone.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary((IWorld)worldIn, windOffsetter);
            if (shouldPlaceOnCeiling) {
                ceilingDripstone.placeBlocks((IWorld)worldIn, rand, windOffsetter);
            }
            if (shouldPlaceOnFloor) {
                floorDripstone.placeBlocks((IWorld)worldIn, rand, windOffsetter);
            }
            return true;
        }
        return false;
    }

    private static LargeDripstone makeDripstone(BlockPos root, boolean pointingUp, Random rand, int radius, FloatProvider bluntness, FloatProvider scale) {
        return new LargeDripstone(root, pointingUp, radius, bluntness.sample(rand), scale.sample(rand));
    }

    static final class LargeDripstone {
        private BlockPos root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        private LargeDripstone(BlockPos root, boolean pontingUp, int radius, double bluntness, double scale) {
            this.root = root;
            this.pointingUp = pontingUp;
            this.radius = radius;
            this.bluntness = bluntness;
            this.scale = scale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        private int getMinY() {
            return this.pointingUp ? this.root.func_177956_o() : this.root.func_177956_o() - this.getHeight();
        }

        private int getMaxY() {
            return !this.pointingUp ? this.root.func_177956_o() : this.root.func_177956_o() + this.getHeight();
        }

        private boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(IWorld worldIn, WindOffsetter windOffsetter) {
            while (this.radius > 1) {
                BlockPos.Mutable pos = this.root.func_239590_i_();
                int height = Math.min(10, this.getHeight());
                for (int index = 0; index < height; ++index) {
                    if (worldIn.func_180495_p((BlockPos)pos).func_177230_c() == Blocks.field_150353_l) {
                        return false;
                    }
                    if (DripstoneUtils.isCircleMostlyEmbeddedInStone(worldIn, windOffsetter.offset((BlockPos)pos), this.radius)) {
                        this.root = pos;
                        return true;
                    }
                    pos.func_189536_c(this.pointingUp ? Direction.DOWN : Direction.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float radius) {
            return (int)DripstoneUtils.getDripstoneHeight(radius, this.radius, this.scale, this.bluntness);
        }

        private void placeBlocks(IWorld worldIn, Random rand, WindOffsetter windOffsetter) {
            for (int xRadius = -this.radius; xRadius <= this.radius; ++xRadius) {
                block1: for (int zRadius = -this.radius; zRadius <= this.radius; ++zRadius) {
                    int height;
                    float radius = MathHelper.func_76129_c((float)(xRadius * xRadius + zRadius * zRadius));
                    if (!(radius <= (float)this.radius) || (height = this.getHeightAtRadius(radius)) <= 0) continue;
                    if ((double)rand.nextFloat() < 0.2) {
                        height = (int)((float)height * MathUtils.randomBetween(rand, 0.8f, 1.0f));
                    }
                    BlockPos.Mutable pos = this.root.func_177982_a(xRadius, 0, zRadius).func_239590_i_();
                    boolean shouldPlace = false;
                    for (int index = 0; index < height; ++index) {
                        BlockPos blockPos = windOffsetter.offset((BlockPos)pos);
                        if (DripstoneUtils.isEmptyOrWaterOrLava(worldIn, blockPos)) {
                            shouldPlace = true;
                            Block block = (Block)CCBBlocks.DRIPSTONE_BLOCK.get();
                            worldIn.func_180501_a(blockPos, block.func_176223_P(), 2);
                        } else if (shouldPlace && worldIn.func_180495_p(blockPos).func_235714_a_((ITag)BlockTags.field_242172_aH)) continue block1;
                        pos.func_189536_c(this.pointingUp ? Direction.UP : Direction.DOWN);
                    }
                }
            }
        }

        private boolean isSuitableForWind(LargeDripstoneConfig config) {
            return this.radius >= config.minRadiusForWind && this.bluntness >= (double)config.minBluntnessForWind;
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final Vector3d windSpeed;

        private WindOffsetter(int originY, Random rand, FloatProvider windOffset) {
            this.originY = originY;
            float windMotion = windOffset.sample(rand);
            float windSpeed = MathUtils.randomBetween(rand, 0.0f, (float)Math.PI);
            this.windSpeed = new Vector3d((double)(MathHelper.func_76134_b((float)windSpeed) * windMotion), 0.0, (double)(MathHelper.func_76126_a((float)windSpeed) * windMotion));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        private static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        private BlockPos offset(BlockPos pos) {
            if (this.windSpeed == null) {
                return pos;
            }
            int originY = this.originY - pos.func_177956_o();
            Vector3d windSpeed = this.windSpeed.func_186678_a((double)originY);
            return pos.func_177963_a(windSpeed.field_72450_a, 0.0, windSpeed.field_72449_c);
        }
    }
}

