/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.stateproviders;

import com.blackgear.cavesandcliffs.common.utils.math.UniformInt;
import com.blackgear.cavesandcliffs.core.registries.CCBBlockStateProviderTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;

public class RandomizedIntBlockStateProvider
extends BlockStateProvider {
    public static final Codec<RandomizedIntBlockStateProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.field_236796_a_.fieldOf("source").forGetter(config -> config.source), (App)Codec.STRING.fieldOf("property").forGetter(config -> config.propertyName), (App)UniformInt.CODEC.fieldOf("values").forGetter(config -> config.values)).apply((Applicative)instance, RandomizedIntBlockStateProvider::new));
    private final BlockStateProvider source;
    private final String propertyName;
    @Nullable
    private IntegerProperty property;
    private final UniformInt values;

    public RandomizedIntBlockStateProvider(BlockStateProvider source, IntegerProperty property, UniformInt values) {
        this.source = source;
        this.property = property;
        this.propertyName = property.func_177701_a();
        this.values = values;
        Collection allowedValues = property.func_177700_c();
        for (int value = values.getMinValue(); value <= values.getMaxValue(); ++value) {
            if (allowedValues.contains(value)) continue;
            throw new IllegalArgumentException("Property value out of range: " + property.func_177701_a() + ": " + value);
        }
    }

    public RandomizedIntBlockStateProvider(BlockStateProvider source, String propertyName, UniformInt values) {
        this.source = source;
        this.propertyName = propertyName;
        this.values = values;
    }

    protected BlockStateProviderType<?> func_230377_a_() {
        return (BlockStateProviderType)CCBBlockStateProviderTypes.RANDOMIZED_INT_STATE_PROVIDER.get();
    }

    public BlockState func_225574_a_(Random randomIn, BlockPos blockPosIn) {
        BlockState state = this.source.func_225574_a_(randomIn, blockPosIn);
        if (this.property == null || !state.func_235901_b_((Property)this.property)) {
            this.property = RandomizedIntBlockStateProvider.findProperty(state, this.propertyName);
        }
        return (BlockState)state.func_206870_a((Property)this.property, (Comparable)Integer.valueOf(this.values.sample(randomIn)));
    }

    private static IntegerProperty findProperty(BlockState state, String name) {
        Collection properties = state.func_235904_r_();
        Optional<IntegerProperty> integerProperty = properties.stream().filter(property -> property.func_177701_a().equals(name)).filter(property -> property instanceof IntegerProperty).map(property -> (IntegerProperty)property).findAny();
        return integerProperty.orElseThrow(() -> new IllegalArgumentException("Illegal property: " + name));
    }
}

