/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries.api;

import com.blackgear.bgcore.core.api.CoreRegistries;
import com.blackgear.cavesandcliffs.common.items.InjectedBlockItem;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class CCBRegistries
extends CoreRegistries {
    private final DeferredRegister<Block> vanillaBlocks = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"minecraft");
    private final DeferredRegister<Item> vanillaItems = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"minecraft");
    public final DeferredRegister<BlockStateProviderType<?>> blockStateProviderTypes;

    public CCBRegistries(String modId) {
        super(modId);
        this.blockStateProviderTypes = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_STATE_PROVIDER_TYPES, (String)modId);
    }

    public DeferredRegister<Block> getVanillaBlocks() {
        return this.vanillaBlocks;
    }

    public DeferredRegister<Item> getVanillaItems() {
        return this.vanillaItems;
    }

    public DeferredRegister<BlockStateProviderType<?>> getBlockStateProviderTypes() {
        return this.blockStateProviderTypes;
    }

    public <B extends Block> RegistryObject<B> registerInjectedBlock(String key, Supplier<Item> followItem, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        RegistryObject block = this.getBlocks().register(key, supplier);
        this.getItems().register(key, () -> new InjectedBlockItem(followItem, (Block)block.get(), new Item.Properties().func_200916_a(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> registerVanillaNonStackableBlock(String key, Supplier<? extends B> blockSupplier, ItemGroup group) {
        RegistryObject block = this.vanillaBlocks.register(key, blockSupplier);
        this.vanillaItems.register(key, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200917_a(1).func_200916_a(group)));
        return block;
    }

    public <I extends Item> RegistryObject<I> registerVanillaItem(String key, Supplier<? extends I> item) {
        return this.vanillaItems.register(key, item);
    }

    public <P extends BlockStateProvider> RegistryObject<BlockStateProviderType<P>> registerBlockStateProviderType(String key, Codec<P> provider) {
        return this.blockStateProviderTypes.register(key, () -> new BlockStateProviderType(provider));
    }

    public <FC extends IFeatureConfig, F extends Structure<FC>> StructureFeature<FC, F> registerStructureFeature(String key, StructureFeature<FC, F> structure) {
        ResourceLocation location = new ResourceLocation(this.id, key);
        if (WorldGenRegistries.field_243654_f.func_148742_b().contains(location)) {
            throw new IllegalStateException("The Configured Structure Feature " + key + "already exists in the registry");
        }
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)location, structure);
        return structure;
    }
}

