/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries.other.utils;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class ItemUtils {
    public static ActionResult<ItemStack> startUsingInstantly(World worldIn, PlayerEntity player, Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)player.func_184586_b(hand));
    }

    public static ItemStack createFilledResult(ItemStack emptyBucket, PlayerEntity player, ItemStack filledBucket, boolean hasEmptyBucket) {
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        if (hasEmptyBucket && isCreative) {
            if (!player.field_71071_by.func_70431_c(filledBucket)) {
                player.field_71071_by.func_70441_a(filledBucket);
            }
            return emptyBucket;
        }
        if (!isCreative) {
            emptyBucket.func_190918_g(1);
        }
        if (emptyBucket.func_190926_b()) {
            return filledBucket;
        }
        if (!player.field_71071_by.func_70441_a(filledBucket)) {
            player.func_71019_a(filledBucket, false);
        }
        return emptyBucket;
    }

    public static ItemStack createFilledResult(ItemStack emptyBucket, PlayerEntity player, ItemStack filledBucket) {
        return ItemUtils.createFilledResult(emptyBucket, player, filledBucket, true);
    }

    public static void onContainerDestroyed(ItemEntity entityIn, Stream<ItemStack> stream) {
        World worldIn = entityIn.field_70170_p;
        if (!worldIn.field_72995_K) {
            stream.forEach(item -> worldIn.func_217376_c((Entity)new ItemEntity(worldIn, entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_(), item)));
        }
    }

    public static Optional<ActionResultType> bucketMobPickup(PlayerEntity playerEntity, Hand hand, LivingEntity entityIn, SoundEvent soundEvent, Supplier<ItemStack> itemStackSupplier) {
        ItemStack heldItem = playerEntity.func_184586_b(hand);
        if (heldItem.func_77973_b() == Items.field_151131_as && entityIn.func_70089_S()) {
            entityIn.func_184185_a(soundEvent, 1.0f, 1.0f);
            heldItem.func_190918_g(1);
            ItemStack filledBucket = itemStackSupplier.get();
            World worldIn = entityIn.field_70170_p;
            if (!worldIn.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)playerEntity, filledBucket);
            }
            if (heldItem.func_190926_b()) {
                playerEntity.func_184611_a(hand, filledBucket);
            } else if (!playerEntity.field_71071_by.func_70441_a(filledBucket)) {
                playerEntity.func_71019_a(filledBucket, false);
            }
            entityIn.func_70106_y();
            return Optional.of(ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K));
        }
        return Optional.empty();
    }
}

