/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries.other.utils;

import com.blackgear.cavesandcliffs.common.utils.math.UniformInt;
import com.blackgear.cavesandcliffs.core.registries.CCBParticleTypes;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.blackgear.cavesandcliffs.core.registries.other.utils.ParticleUtils;
import net.minecraft.block.BlockState;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class WorldUtils {
    public static void playWorldEvent(int event, World worldIn, BlockPos pos, int value) {
        switch (event) {
            case 3002: {
                if (value >= 0 && value < Direction.Axis.values().length) {
                    ParticleUtils.spawnParticlesAlongAxis(Direction.Axis.values()[value], worldIn, pos, 0.125, (IParticleData)CCBParticleTypes.ELECTRIC_SPARK.get(), UniformInt.of(10, 19));
                    break;
                }
                ParticleUtils.spawnParticlesOnBlockFaces(worldIn, pos, (IParticleData)CCBParticleTypes.ELECTRIC_SPARK.get(), UniformInt.of(3, 5));
                break;
            }
            case 3003: {
                ParticleUtils.spawnParticlesOnBlockFaces(worldIn, pos, (IParticleData)CCBParticleTypes.WAX_ON.get(), UniformInt.of(3, 5));
                worldIn.func_184133_a(null, pos, (SoundEvent)CCBSoundEvents.ITEM_HONEYCOMB_WAX_ON.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case 3004: {
                ParticleUtils.spawnParticlesOnBlockFaces(worldIn, pos, (IParticleData)CCBParticleTypes.WAX_OFF.get(), UniformInt.of(3, 5));
                break;
            }
            case 3005: {
                ParticleUtils.spawnParticlesOnBlockFaces(worldIn, pos, (IParticleData)CCBParticleTypes.SCRAPE.get(), UniformInt.of(3, 5));
            }
        }
    }

    public static boolean canSeeSkyFromBelowWater(IWorld worldIn, BlockPos pos) {
        if (pos.func_177956_o() > worldIn.func_181545_F()) {
            return worldIn.func_226660_f_(pos);
        }
        BlockPos belowSeaLevel = new BlockPos(pos.func_177958_n(), worldIn.func_181545_F(), pos.func_177952_p());
        if (!worldIn.func_226660_f_(belowSeaLevel)) {
            return false;
        }
        belowSeaLevel = belowSeaLevel.func_177977_b();
        while (belowSeaLevel.func_177956_o() > pos.func_177956_o()) {
            BlockState stateBelowSeaLevel = worldIn.func_180495_p(belowSeaLevel);
            if (stateBelowSeaLevel.getLightValue((IBlockReader)worldIn, belowSeaLevel) > 0 && !stateBelowSeaLevel.func_185904_a().func_76224_d()) {
                return false;
            }
            belowSeaLevel = belowSeaLevel.func_177977_b();
        }
        return true;
    }
}

