/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.core.common.entity;

import com.blackgear.cavesandcliffs.common.blocks.LightningRodBlock;
import com.blackgear.cavesandcliffs.common.blocks.WeatheringCopper;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockPosUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.WorldUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightningBoltEntity.class})
public abstract class LightningBoltEntityMixin
extends Entity {
    @Shadow
    private int field_70262_b;
    @Shadow
    private int field_70263_c;
    @Shadow
    public long field_70264_a;
    @Shadow
    @Final
    private boolean field_184529_d;
    @Shadow
    @Nullable
    private ServerPlayerEntity field_204810_e;

    @Shadow
    protected abstract void func_195053_a(int var1);

    public LightningBoltEntityMixin(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    private void powerLightningRod() {
        BlockPos pos = this.func_233580_cy_().func_177977_b();
        BlockState state = this.field_70170_p.func_180495_p(pos);
        if (state.func_177230_c().equals(CCBBlocks.LIGHTNING_ROD.get())) {
            ((LightningRodBlock)state.func_177230_c()).onLightningStrike(state, this.field_70170_p, pos);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void worldTick(CallbackInfo info) {
        super.func_70071_h_();
        if (this.field_70262_b == 2) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f);
        } else {
            Difficulty difficulty = this.field_70170_p.func_175659_aa();
            if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
                this.func_195053_a(4);
            }
            this.powerLightningRod();
        }
        --this.field_70262_b;
        if (this.field_70262_b < 0) {
            if (this.field_70263_c == 0) {
                this.func_70106_y();
            } else if (this.field_70262_b < -this.field_70146_Z.nextInt(10)) {
                --this.field_70263_c;
                this.field_70262_b = 1;
                this.field_70264_a = this.field_70146_Z.nextLong();
                this.func_195053_a(0);
            }
        }
        if (this.field_70262_b >= 0) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_225605_c_(2);
            } else if (!this.field_184529_d) {
                List list = this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.func_226277_ct_() - 3.0, this.func_226278_cu_() - 3.0, this.func_226281_cx_() - 3.0, this.func_226277_ct_() + 3.0, this.func_226278_cu_() + 6.0 + 3.0, this.func_226281_cx_() + 3.0), Entity::func_70089_S);
                for (Entity entity : list) {
                    entity.func_241841_a((ServerWorld)this.field_70170_p, (LightningBoltEntity)this);
                }
                if (this.field_204810_e != null) {
                    CriteriaTriggers.field_204812_E.func_204814_a(this.field_204810_e, (Collection)list);
                }
            }
        }
    }

    private static void clearCopperOnLightningStrike(World worldIn, BlockPos pos) {
        BlockState state;
        BlockPos blockPos;
        BlockState lightningRod = worldIn.func_180495_p(pos);
        if (lightningRod.func_177230_c() == CCBBlocks.LIGHTNING_ROD.get()) {
            blockPos = pos.func_177972_a(((Direction)lightningRod.func_177229_b((Property)LightningRodBlock.field_176387_N)).func_176734_d());
            state = worldIn.func_180495_p(blockPos);
        } else {
            blockPos = pos;
            state = lightningRod;
        }
        if (state.func_177230_c() instanceof WeatheringCopper) {
            worldIn.func_175656_a(blockPos, WeatheringCopper.getFirst(worldIn.func_180495_p(blockPos)));
            BlockPos.Mutable mutable = pos.func_239590_i_();
            int chance = worldIn.field_73012_v.nextInt(3) + 3;
            for (int index = 0; index < chance; ++index) {
                int radius = worldIn.field_73012_v.nextInt(8) + 1;
                LightningBoltEntityMixin.randomWalkCleaningCopper(worldIn, blockPos, mutable, radius);
            }
        }
    }

    private static void randomWalkCleaningCopper(World worldIn, BlockPos pos, BlockPos.Mutable mutable, int radius) {
        Optional<BlockPos> randomStep;
        mutable.func_189533_g((Vector3i)pos);
        for (int index = 0; index < radius && (randomStep = LightningBoltEntityMixin.randomStepCleaningCopper(worldIn, (BlockPos)mutable)).isPresent(); ++index) {
            mutable.func_189533_g((Vector3i)randomStep.get());
        }
    }

    private static Optional<BlockPos> randomStepCleaningCopper(World worldIn, BlockPos pos) {
        BlockPos blockPos;
        BlockState state;
        Iterator<BlockPos> blockPosIterator = BlockPosUtils.randomInCube(worldIn.field_73012_v, 10, pos, 1).iterator();
        do {
            if (blockPosIterator.hasNext()) continue;
            return Optional.empty();
        } while (!((state = worldIn.func_180495_p(blockPos = blockPosIterator.next())).func_177230_c() instanceof WeatheringCopper));
        BlockPos finalBlockPos = blockPos;
        WeatheringCopper.getPrevious(state).ifPresent(stateIn -> worldIn.func_175656_a(finalBlockPos, stateIn));
        WorldUtils.playWorldEvent(3002, worldIn, blockPos, -1);
        return Optional.of(blockPos);
    }
}

