/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.core.common.item;

import com.blackgear.cavesandcliffs.common.blocks.WeatheringCopper;
import com.blackgear.cavesandcliffs.common.items.HoneyCombItem;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.blackgear.cavesandcliffs.core.registries.other.utils.ActionResultUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.WorldUtils;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AxeItem.class})
public class AxeItemMixin
extends ToolItem {
    protected AxeItemMixin(float attackDamageIn, float attackSpeedIn, IItemTier tier, Set<Block> effectiveBlocksIn, Item.Properties builder) {
        super(attackDamageIn, attackSpeedIn, tier, effectiveBlocksIn, builder);
    }

    @Inject(method={"onItemUse"}, at={@At(value="TAIL")}, cancellable=true)
    public void onItemUse(ItemUseContext context, CallbackInfoReturnable<ActionResultType> info) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        BlockState state = worldIn.func_180495_p(pos);
        Optional<BlockState> previous = WeatheringCopper.getPrevious(state);
        Optional<BlockState> waxable = Optional.ofNullable(HoneyCombItem.WAX_OFF_BY_BLOCK.get((Object)state.func_177230_c())).map(blockIn -> BlockUtils.withPropertiesOf(blockIn, state));
        Optional<Object> block = Optional.empty();
        if (previous.isPresent()) {
            worldIn.func_184133_a(player, pos, (SoundEvent)CCBSoundEvents.ITEM_AXE_SCRAPE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            WorldUtils.playWorldEvent(3005, worldIn, pos, 0);
            block = previous;
        } else if (waxable.isPresent()) {
            worldIn.func_184133_a(player, pos, (SoundEvent)CCBSoundEvents.ITEM_AXE_WAX_OFF.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            WorldUtils.playWorldEvent(3004, worldIn, pos, 0);
            block = waxable;
        }
        if (block.isPresent()) {
            worldIn.func_180501_a(pos, (BlockState)block.get(), 11);
            if (player != null) {
                context.func_195996_i().func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(context.func_221531_n()));
                info.setReturnValue((Object)ActionResultUtils.sidedSuccess(worldIn.field_72995_K));
            } else {
                info.setReturnValue((Object)ActionResultType.PASS);
            }
        }
    }
}

