/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.core.common.world.gen.structure;

import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.api.HeightLimitReader;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.LootTables;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.MineshaftPieces;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MineshaftPieces.Corridor.class})
public abstract class MineshaftPieces$CorridorMixin
extends MineshaftPieces.Piece {
    @Shadow
    @Final
    private int field_74955_d;
    @Shadow
    @Final
    private boolean field_74956_b;
    @Shadow
    @Final
    private boolean field_74958_a;
    @Shadow
    private boolean field_74957_c;

    @Shadow
    protected abstract void func_189921_a(ISeedReader var1, MutableBoundingBox var2, int var3, int var4, int var5, int var6, int var7, Random var8);

    @Shadow
    protected abstract void func_189922_a(ISeedReader var1, MutableBoundingBox var2, Random var3, float var4, int var5, int var6, int var7);

    public MineshaftPieces$CorridorMixin(IStructurePieceType structurePieceTypeIn, int componentTypeIn, MineshaftStructure.Type typeIn) {
        super(structurePieceTypeIn, componentTypeIn, typeIn);
    }

    @Inject(method={"func_230383_a_"}, at={@At(value="HEAD")}, cancellable=true)
    public void func_230383_a_(ISeedReader worldIn, StructureManager structure, ChunkGenerator generator, Random rand, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (this.func_74860_a((IBlockReader)worldIn, boundingBox)) {
            cir.setReturnValue((Object)false);
        } else {
            int z;
            int x;
            int length = this.field_74955_d * 5 - 1;
            BlockState plankState = this.func_189917_F_();
            this.func_175804_a(worldIn, boundingBox, 0, 0, 0, 2, 1, length, field_202556_l, field_202556_l, false);
            this.func_189914_a(worldIn, boundingBox, rand, 0.8f, 0, 2, 0, 2, 2, length, field_202556_l, field_202556_l, false, false);
            if (this.field_74956_b) {
                this.func_189914_a(worldIn, boundingBox, rand, 0.6f, 0, 0, 0, 2, 1, length, Blocks.field_196553_aF.func_176223_P(), field_202556_l, false, true);
            }
            for (x = 0; x < this.field_74955_d; ++x) {
                int zIn;
                z = 2 + x * 5;
                this.func_189921_a(worldIn, boundingBox, 0, 0, z, 2, 2, rand);
                this.func_189922_a(worldIn, boundingBox, rand, 0.1f, 0, 2, z - 1);
                this.func_189922_a(worldIn, boundingBox, rand, 0.1f, 2, 2, z - 1);
                this.func_189922_a(worldIn, boundingBox, rand, 0.1f, 0, 2, z + 1);
                this.func_189922_a(worldIn, boundingBox, rand, 0.1f, 2, 2, z + 1);
                this.func_189922_a(worldIn, boundingBox, rand, 0.05f, 0, 2, z - 2);
                this.func_189922_a(worldIn, boundingBox, rand, 0.05f, 2, 2, z - 2);
                this.func_189922_a(worldIn, boundingBox, rand, 0.05f, 0, 2, z + 2);
                this.func_189922_a(worldIn, boundingBox, rand, 0.05f, 2, 2, z + 2);
                if (rand.nextInt(100) == 0) {
                    this.func_186167_a(worldIn, boundingBox, rand, 2, 0, z - 1, LootTables.field_186424_f);
                }
                if (rand.nextInt(100) == 0) {
                    this.func_186167_a(worldIn, boundingBox, rand, 0, 0, z + 1, LootTables.field_186424_f);
                }
                if (!this.field_74956_b || this.field_74957_c) continue;
                int yIn = this.func_74862_a(0);
                int offset = z - 1 + rand.nextInt(3);
                int xIn = this.func_74865_a(1, offset);
                BlockPos blockpos = new BlockPos(xIn, yIn, zIn = this.func_74873_b(1, offset));
                if (!boundingBox.func_175898_b((Vector3i)blockpos) || !this.func_189916_b((IWorldReader)worldIn, 1, 0, offset, boundingBox)) continue;
                this.field_74957_c = true;
                worldIn.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity tileEntity = worldIn.func_175625_s(blockpos);
                if (!(tileEntity instanceof MobSpawnerTileEntity)) continue;
                ((MobSpawnerTileEntity)tileEntity).func_145881_a().func_200876_a(EntityType.field_200794_h);
            }
            for (x = 0; x <= 2; ++x) {
                for (z = 0; z <= length; ++z) {
                    this.setPlanksBlock(worldIn, boundingBox, plankState, x, -1, z);
                }
            }
            this.fillSupportBeam(worldIn, boundingBox, 0, -1, 2);
            if (this.field_74955_d > 1) {
                z = length - 2;
                this.fillSupportBeam(worldIn, boundingBox, 0, -1, z);
            }
            if (this.field_74958_a) {
                BlockState railState = (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.NORTH_SOUTH);
                for (int zIn = 0; zIn <= length; ++zIn) {
                    BlockState posState = this.func_175807_a((IBlockReader)worldIn, 1, -1, zIn, boundingBox);
                    if (posState.func_196958_f() || !posState.func_200015_d((IBlockReader)worldIn, new BlockPos(this.func_74865_a(1, zIn), this.func_74862_a(-1), this.func_74873_b(1, zIn)))) continue;
                    float chance = this.func_189916_b((IWorldReader)worldIn, 1, 0, zIn, boundingBox) ? 0.7f : 0.9f;
                    this.func_175809_a(worldIn, boundingBox, rand, chance, 1, 0, zIn, railState);
                }
            }
            cir.setReturnValue((Object)true);
        }
    }

    private void fillSupportBeam(ISeedReader world, MutableBoundingBox boundingBox, int x, int y, int z) {
        BlockState logState = this.getLogBlock();
        BlockState plankState = this.func_189917_F_();
        if (this.func_175807_a((IBlockReader)world, x, y, z, boundingBox).func_203425_a(plankState.func_177230_c())) {
            this.fillPillarDownOrChainUp(world, logState, x, y, z, boundingBox);
        }
        if (this.func_175807_a((IBlockReader)world, x + 2, y, z, boundingBox).func_203425_a(plankState.func_177230_c())) {
            this.fillPillarDownOrChainUp(world, logState, x + 2, y, z, boundingBox);
        }
    }

    protected void func_175808_b(ISeedReader world, BlockState state, int x, int y, int z, MutableBoundingBox boundingBox) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (boundingBox.func_175898_b((Vector3i)mutable)) {
            int height = mutable.func_177956_o();
            while (this.canReplace(world.func_180495_p((BlockPos)mutable)) && mutable.func_177956_o() > HeightLimitReader.getBottomY() + 1) {
                mutable.func_189536_c(Direction.DOWN);
            }
            if (this.isNotRailOrLava(world.func_180495_p((BlockPos)mutable))) {
                while (mutable.func_177956_o() < height) {
                    mutable.func_189536_c(Direction.UP);
                    world.func_180501_a((BlockPos)mutable, state, 3);
                }
            }
        }
    }

    protected void fillPillarDownOrChainUp(ISeedReader world, BlockState state, int x, int y, int z, MutableBoundingBox boundingBox) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (boundingBox.func_175898_b((Vector3i)mutable)) {
            int height = mutable.func_177956_o();
            int length = 1;
            boolean canPlacePillars = true;
            boolean canPlaceChains = true;
            while (canPlaceChains || canPlacePillars) {
                boolean canReplace;
                BlockState blockState;
                if (canPlacePillars) {
                    mutable.func_185336_p(height - length);
                    blockState = world.func_180495_p((BlockPos)mutable);
                    boolean bl = canReplace = this.canReplace(blockState) && !blockState.func_203425_a(Blocks.field_150353_l);
                    if (!canReplace && this.isNotRailOrLava(blockState)) {
                        MineshaftPieces$CorridorMixin.fillColumnBetween(world, state, mutable, height - length + 1, height);
                        return;
                    }
                    boolean bl2 = canPlacePillars = length <= 20 && canReplace && mutable.func_177956_o() > HeightLimitReader.getBottomY() + 1;
                }
                if (canPlaceChains) {
                    mutable.func_185336_p(height + length);
                    blockState = world.func_180495_p((BlockPos)mutable);
                    canReplace = this.canReplace(blockState);
                    if (!canReplace && this.canHangChainBelow((IWorldReader)world, (BlockPos)mutable, blockState)) {
                        world.func_180501_a((BlockPos)MineshaftPieces$CorridorMixin.setY(mutable, height + 1), this.func_189919_b(), 2);
                        MineshaftPieces$CorridorMixin.fillColumnBetween(world, Blocks.field_235341_dI_.func_176223_P(), mutable, height + 2, height + length);
                        return;
                    }
                    canPlaceChains = length <= 50 && canReplace && mutable.func_177956_o() < HeightLimitReader.getTopY() - 1;
                }
                ++length;
            }
        }
    }

    private boolean canReplace(BlockState state) {
        return state.func_196958_f() || state.func_185904_a().func_76224_d() || state.func_203425_a((Block)CCBBlocks.GLOW_LICHEN.get()) || state.func_203425_a(Blocks.field_203198_aQ) || state.func_203425_a(Blocks.field_203199_aR);
    }

    private static BlockPos.Mutable setY(BlockPos.Mutable pos, int y) {
        pos.func_185336_p(y);
        return pos;
    }

    private static void fillColumnBetween(ISeedReader worldIn, BlockState state, BlockPos.Mutable pos, int x, int z) {
        for (int y = x; y < z; ++y) {
            worldIn.func_180501_a((BlockPos)MineshaftPieces$CorridorMixin.setY(pos, y), state, 2);
        }
    }

    private boolean isNotRailOrLava(BlockState state) {
        return !state.func_203425_a(Blocks.field_150448_aq) && !state.func_203425_a(Blocks.field_150353_l);
    }

    private boolean canHangChainBelow(IWorldReader world, BlockPos pos, BlockState state) {
        return Block.func_220055_a((IWorldReader)world, (BlockPos)pos, (Direction)Direction.DOWN) && !(state.func_177230_c() instanceof FallingBlock);
    }

    @Inject(method={"placeSupport"}, at={@At(value="HEAD")}, cancellable=true)
    private void placeSupport(ISeedReader world, MutableBoundingBox boundingBox, int minX, int minY, int z, int maxY, int maxX, Random rand, CallbackInfo info) {
        if (this.func_189918_a((IBlockReader)world, boundingBox, minX, maxX, maxY, z)) {
            BlockState plankState = this.func_189917_F_();
            BlockState fenceState = this.func_189919_b();
            this.func_175804_a(world, boundingBox, minX, minY, z, minX, maxY - 1, z, (BlockState)fenceState.func_206870_a((Property)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), field_202556_l, false);
            this.func_175804_a(world, boundingBox, maxX, minY, z, maxX, maxY - 1, z, (BlockState)fenceState.func_206870_a((Property)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), field_202556_l, false);
            if (rand.nextInt(4) == 0) {
                this.func_175804_a(world, boundingBox, minX, maxY, z, minX, maxY, z, plankState, field_202556_l, false);
                this.func_175804_a(world, boundingBox, maxX, maxY, z, maxX, maxY, z, plankState, field_202556_l, false);
            } else {
                this.func_175804_a(world, boundingBox, minX, maxY, z, maxX, maxY, z, plankState, field_202556_l, false);
                this.func_175809_a(world, boundingBox, rand, 0.05f, minX + 1, maxY, z - 1, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH));
                this.func_175809_a(world, boundingBox, rand, 0.05f, minX + 1, maxY, z + 1, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH));
            }
        }
    }

    @Inject(method={"placeCobWeb"}, at={@At(value="HEAD")}, cancellable=true)
    private void placeCobWeb(ISeedReader world, MutableBoundingBox boundingBox, Random rand, float threshold, int x, int y, int z, CallbackInfo info) {
        if (this.func_189916_b((IWorldReader)world, x, y, z, boundingBox) && rand.nextFloat() < threshold && this.hasSturdyNeighbours(world, boundingBox, x, y, z, 2)) {
            this.func_175811_a(world, Blocks.field_196553_aF.func_176223_P(), x, y, z, boundingBox);
        }
    }

    private boolean hasSturdyNeighbours(ISeedReader world, MutableBoundingBox boundingBox, int x, int y, int z, int chance) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        int length = 0;
        for (Direction direction : Direction.values()) {
            mutable.func_189536_c(direction);
            if (boundingBox.func_175898_b((Vector3i)mutable) && world.func_180495_p((BlockPos)mutable).func_224755_d((IBlockReader)world, (BlockPos)mutable, direction.func_176734_d()) && ++length >= chance) {
                return true;
            }
            mutable.func_189536_c(direction.func_176734_d());
        }
        return false;
    }

    @Unique
    protected void setPlanksBlock(ISeedReader world, MutableBoundingBox boundingBox, BlockState state, int x, int y, int z) {
        BlockPos.Mutable pos;
        BlockState blockState;
        if (this.func_189916_b((IWorldReader)world, x, y, z, boundingBox) && ((blockState = world.func_180495_p((BlockPos)(pos = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z))))).func_196958_f() || blockState.func_203425_a(Blocks.field_235341_dI_))) {
            world.func_180501_a((BlockPos)pos, state, 2);
        }
    }

    @Unique
    protected BlockState getLogBlock() {
        switch (this.field_189920_a) {
            default: {
                return Blocks.field_196617_K.func_176223_P();
            }
            case MESA: 
        }
        return Blocks.field_196623_P.func_176223_P();
    }
}

