/*
 * Decompiled with CFR 0.152.
 */
package ga.hallzmine.cityblocks.blocks;

import ga.hallzmine.cityblocks.baseBlocks.OrientableBlockBase;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class RoadBarrierBlock
extends OrientableBlockBase {
    protected static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();

    public RoadBarrierBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(5.0f, 5.0f).func_226896_b_());
        this.runCalculation(Stream.of(Block.func_208617_a((double)12.0, (double)-1.0, (double)3.75, (double)15.0, (double)12.0, (double)4.75), Block.func_208617_a((double)1.0, (double)-1.0, (double)3.75, (double)4.0, (double)12.0, (double)4.75), Block.func_208617_a((double)12.0, (double)-1.0, (double)11.1795, (double)15.0, (double)12.0, (double)12.1795), Block.func_208617_a((double)1.0, (double)-1.0, (double)11.1795, (double)4.0, (double)12.0, (double)12.1795), Block.func_208617_a((double)0.0, (double)9.0, (double)9.275, (double)16.0, (double)13.0, (double)10.275), Block.func_208617_a((double)0.0, (double)9.0, (double)5.67234, (double)16.0, (double)13.0, (double)6.67234), Block.func_208617_a((double)0.0, (double)4.0, (double)11.275, (double)16.0, (double)8.0, (double)12.275), Block.func_208617_a((double)0.0, (double)4.0, (double)3.67234, (double)16.0, (double)8.0, (double)4.67234)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
    }

    protected static void calculateShapes(Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, VoxelShapes.func_197880_a()};
        int times = (to.func_176736_b() - Direction.NORTH.func_176736_b() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = VoxelShapes.func_197872_a((VoxelShape)buffer[1], (VoxelShape)VoxelShapes.func_197873_a((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = VoxelShapes.func_197880_a();
        }
        SHAPES.put(to, buffer[0]);
    }

    protected void runCalculation(VoxelShape shape) {
        for (Direction direction : Direction.values()) {
            RoadBarrierBlock.calculateShapes(direction, shape);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((Property)HorizontalBlock.field_185512_D));
    }
}

