/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Action;
import com.mrcrayfish.controllable.client.ActionVisibility;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.ButtonBindings;
import com.mrcrayfish.controllable.client.ControllerIcons;
import com.mrcrayfish.controllable.client.RadialMenuHandler;
import com.mrcrayfish.controllable.event.AvailableActionsEvent;
import com.mrcrayfish.controllable.event.GatherActionsEvent;
import com.mrcrayfish.controllable.event.RenderAvailableActionsEvent;
import com.mrcrayfish.controllable.event.RenderPlayerPreviewEvent;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.ContainerBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RenderEvents {
    public static final ResourceLocation CONTROLLER_BUTTONS = new ResourceLocation("controllable", "textures/gui/buttons.png");
    private Map<Integer, Action> actions = new HashMap<Integer, Action>();
    private int selectedRadialIndex = -1;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && mc.field_71439_g != null && !mc.field_71474_y.field_74319_N) {
            boolean verbose;
            this.actions.clear();
            LinkedHashMap<ButtonBinding, Action> actionMap = new LinkedHashMap<ButtonBinding, Action>();
            ActionVisibility visibility = (ActionVisibility)((Object)Config.CLIENT.options.showActions.get());
            if (visibility == ActionVisibility.NONE) {
                return;
            }
            boolean bl = verbose = visibility == ActionVisibility.ALL;
            if (mc.field_71462_r instanceof ContainerScreen) {
                if (mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                    Slot slot;
                    ContainerScreen container = (ContainerScreen)mc.field_71462_r;
                    if (container.getSlotUnderMouse() != null && (slot = container.getSlotUnderMouse()).func_75216_d()) {
                        actionMap.put(ButtonBindings.PICKUP_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.pickup_stack", (Object[])new Object[0]), Action.Side.LEFT));
                        actionMap.put(ButtonBindings.SPLIT_STACK, new Action(I18n.func_135052_a((String)"controllable.action.pickup_item", (Object[])new Object[0]), Action.Side.LEFT));
                        actionMap.put(ButtonBindings.QUICK_MOVE, new Action(I18n.func_135052_a((String)"controllable.action.quick_move", (Object[])new Object[0]), Action.Side.LEFT));
                    }
                } else {
                    actionMap.put(ButtonBindings.PICKUP_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.place_stack", (Object[])new Object[0]), Action.Side.LEFT));
                    actionMap.put(ButtonBindings.SPLIT_STACK, new Action(I18n.func_135052_a((String)"controllable.action.place_item", (Object[])new Object[0]), Action.Side.LEFT));
                }
                actionMap.put(ButtonBindings.INVENTORY, new Action(I18n.func_135052_a((String)"controllable.action.close_inventory", (Object[])new Object[0]), Action.Side.RIGHT));
            } else if (mc.field_71462_r == null) {
                if (RadialMenuHandler.instance().isVisible()) {
                    if (RadialMenuHandler.instance().getSelected() != null) {
                        actionMap.put(ButtonBindings.RADIAL_MENU, new Action(I18n.func_135052_a((String)"controllable.action.radial.perform_action", (Object[])new Object[0]), Action.Side.RIGHT));
                    } else {
                        actionMap.put(ButtonBindings.RADIAL_MENU, new Action(I18n.func_135052_a((String)"controllable.action.radial.close_menu", (Object[])new Object[0]), Action.Side.RIGHT));
                    }
                } else {
                    ItemStack currentItem;
                    ItemStack offHandStack;
                    boolean blockHit = mc.field_71476_x != null && mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK;
                    boolean canOpenBlock = false;
                    if (blockHit) {
                        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)mc.field_71476_x;
                        canOpenBlock = mc.field_71441_e.func_180495_p(blockRayTraceResult.func_216350_a()).func_177230_c() instanceof ContainerBlock;
                    }
                    if (!mc.field_71439_g.func_184587_cr()) {
                        if (blockHit) {
                            actionMap.put(ButtonBindings.ATTACK, new Action(I18n.func_135052_a((String)"controllable.action.break", (Object[])new Object[0]), Action.Side.RIGHT));
                        } else {
                            actionMap.put(ButtonBindings.ATTACK, new Action(I18n.func_135052_a((String)"controllable.action.attack", (Object[])new Object[0]), Action.Side.RIGHT));
                        }
                    }
                    if ((offHandStack = mc.field_71439_g.func_184592_cb()).func_77975_n() != UseAction.NONE) {
                        switch (offHandStack.func_77975_n()) {
                            case EAT: {
                                if (!mc.field_71439_g.func_71024_bL().func_75121_c()) break;
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.eat", (Object[])new Object[0]), Action.Side.RIGHT));
                                break;
                            }
                            case DRINK: {
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.drink", (Object[])new Object[0]), Action.Side.RIGHT));
                                break;
                            }
                            case BLOCK: {
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.block", (Object[])new Object[0]), Action.Side.RIGHT));
                                break;
                            }
                            case BOW: {
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.pull_bow", (Object[])new Object[0]), Action.Side.RIGHT));
                            }
                        }
                    }
                    if ((currentItem = mc.field_71439_g.field_71071_by.func_70448_g()).func_77975_n() != UseAction.NONE) {
                        switch (currentItem.func_77975_n()) {
                            case EAT: {
                                if (!mc.field_71439_g.func_71024_bL().func_75121_c()) break;
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.eat", (Object[])new Object[0]), Action.Side.RIGHT));
                                break;
                            }
                            case DRINK: {
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.drink", (Object[])new Object[0]), Action.Side.RIGHT));
                                break;
                            }
                            case BLOCK: {
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.block", (Object[])new Object[0]), Action.Side.RIGHT));
                                break;
                            }
                            case BOW: {
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.pull_bow", (Object[])new Object[0]), Action.Side.RIGHT));
                            }
                        }
                    } else if (currentItem.func_77973_b() instanceof BlockItem) {
                        if (blockHit) {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.place_block", (Object[])new Object[0]), Action.Side.RIGHT));
                        }
                    } else if (!currentItem.func_190926_b() && !mc.field_71439_g.func_184587_cr()) {
                        actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.use_item", (Object[])new Object[0]), Action.Side.RIGHT));
                    }
                    if (!mc.field_71439_g.func_225608_bj_() && blockHit && canOpenBlock && !mc.field_71439_g.func_184587_cr()) {
                        actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.interact", (Object[])new Object[0]), Action.Side.RIGHT));
                    }
                    if (verbose) {
                        actionMap.put(ButtonBindings.JUMP, new Action(I18n.func_135052_a((String)"controllable.action.jump", (Object[])new Object[0]), Action.Side.LEFT));
                    }
                    actionMap.put(ButtonBindings.INVENTORY, new Action(I18n.func_135052_a((String)"controllable.action.inventory", (Object[])new Object[0]), Action.Side.LEFT));
                    if (!(!verbose || mc.field_71439_g.func_184592_cb().func_190926_b() && mc.field_71439_g.field_71071_by.func_70448_g().func_190926_b())) {
                        actionMap.put(ButtonBindings.SWAP_HANDS, new Action(I18n.func_135052_a((String)"controllable.action.swap_hands", (Object[])new Object[0]), Action.Side.LEFT));
                    }
                    if (mc.field_71439_g.func_184218_aH()) {
                        actionMap.put(ButtonBindings.SNEAK, new Action(I18n.func_135052_a((String)"controllable.action.dismount", (Object[])new Object[0]), Action.Side.RIGHT));
                    } else if (verbose) {
                        actionMap.put(ButtonBindings.SNEAK, new Action(I18n.func_135052_a((String)"controllable.action.sneak", (Object[])new Object[0]), Action.Side.RIGHT));
                    }
                    if (!mc.field_71439_g.field_71071_by.func_70448_g().func_190926_b()) {
                        actionMap.put(ButtonBindings.DROP_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.drop_item", (Object[])new Object[0]), Action.Side.LEFT));
                    }
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new AvailableActionsEvent(this.actions));
            MinecraftForge.EVENT_BUS.post((Event)new GatherActionsEvent(actionMap, visibility));
            actionMap.forEach((binding, action) -> this.actions.put(binding.getButton(), (Action)action));
        }
    }

    @SubscribeEvent
    public void onRenderScreen(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74319_N) {
            return;
        }
        if (Controllable.getController() != null) {
            if (Controllable.getInput().getLastUse() <= 0) {
                return;
            }
            this.renderHints();
            this.renderMiniPlayer();
        } else if (mc.field_71462_r == null && ((Boolean)Config.SERVER.restrictToController.get()).booleanValue()) {
            RenderSystem.disableDepthTest();
            int width = mc.func_228018_at_().func_198107_o();
            int height = mc.func_228018_at_().func_198087_p();
            AbstractGui.func_238467_a_((MatrixStack)new MatrixStack(), (int)0, (int)0, (int)width, (int)height, (int)-1072689136);
            AbstractGui.func_238472_a_((MatrixStack)new MatrixStack(), (FontRenderer)mc.field_71466_p, (ITextComponent)new TranslationTextComponent("controllable.gui.controller_only").func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.YELLOW), (int)(width / 2), (int)(height / 2 - 15), (int)-1);
            AbstractGui.func_238472_a_((MatrixStack)new MatrixStack(), (FontRenderer)mc.field_71466_p, (ITextComponent)new TranslationTextComponent("controllable.gui.plug_in_controller"), (int)(width / 2), (int)(height / 2), (int)-1);
            RenderSystem.enableDepthTest();
        }
    }

    private void renderHints() {
        if (!MinecraftForge.EVENT_BUS.post((Event)new RenderAvailableActionsEvent())) {
            Minecraft mc = Minecraft.func_71410_x();
            IngameGui guiIngame = mc.field_71456_v;
            boolean isChatVisible = mc.field_71462_r == null && guiIngame.func_146158_b().field_146253_i.stream().anyMatch(chatLine -> guiIngame.func_73834_c() - chatLine.func_74540_b() < 200);
            int leftIndex = 0;
            int rightIndex = 0;
            for (int button : this.actions.keySet()) {
                Action action = this.actions.get(button);
                Action.Side side = action.getSide();
                int texU = button * 13;
                int texV = ((ControllerIcons)((Object)Config.CLIENT.options.controllerIcons.get())).ordinal() * 13;
                int size = 13;
                int x = side == Action.Side.LEFT ? 5 : mc.func_228018_at_().func_198107_o() - 5 - size;
                int y = mc.func_228018_at_().func_198087_p() + (side == Action.Side.LEFT ? leftIndex : rightIndex) * -15 - size - 5;
                mc.func_110434_K().func_110577_a(CONTROLLER_BUTTONS);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableLighting();
                if (isChatVisible && side == Action.Side.LEFT && leftIndex >= 2) continue;
                MatrixStack matrixStack = new MatrixStack();
                Widget.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)texU, (float)texV, (int)size, (int)size, (int)256, (int)256);
                if (side == Action.Side.LEFT) {
                    mc.field_71466_p.func_238421_b_(matrixStack, action.getDescription(), (float)(x + 18), (float)(y + 3), Color.WHITE.getRGB());
                    ++leftIndex;
                    continue;
                }
                int width = mc.field_71466_p.func_78256_a(action.getDescription());
                mc.field_71466_p.func_238421_b_(matrixStack, action.getDescription(), (float)(x - 5 - width), (float)(y + 3), Color.WHITE.getRGB());
                ++rightIndex;
            }
        }
    }

    private void renderMiniPlayer() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71462_r == null && ((Boolean)Config.CLIENT.options.renderMiniPlayer.get()).booleanValue() && !MinecraftForge.EVENT_BUS.post((Event)new RenderPlayerPreviewEvent())) {
            InventoryScreen.func_228187_a_((int)20, (int)45, (int)20, (float)0.0f, (float)0.0f, (LivingEntity)mc.field_71439_g);
        }
    }
}

