/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.controllable.client.BindingRegistry;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.KeyAdapterBinding;
import com.mrcrayfish.controllable.client.gui.ButtonBindingData;
import com.mrcrayfish.controllable.client.gui.ButtonBindingScreen;
import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.SelectButtonBindingScreen;
import com.mrcrayfish.controllable.client.gui.widget.ButtonBindingButton;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ButtonBindingList
extends AbstractOptionList<Entry> {
    private Screen parent;
    private Map<String, List<ButtonBinding>> categories = new LinkedHashMap<String, List<ButtonBinding>>();

    public ButtonBindingList(Screen parent, Minecraft mc, int widthIn, int heightIn, int topIn, int bottomIn, int itemHeightIn) {
        super(mc, widthIn, heightIn, topIn, bottomIn, itemHeightIn);
        this.parent = parent;
        this.updateList(false);
    }

    public void updateList(boolean showUnbound) {
        this.categories.put("key.categories.movement", new ArrayList());
        this.categories.put("key.categories.gameplay", new ArrayList());
        this.categories.put("key.categories.inventory", new ArrayList());
        this.categories.put("key.categories.creative", new ArrayList());
        this.categories.put("key.categories.multiplayer", new ArrayList());
        this.categories.put("key.categories.ui", new ArrayList());
        this.categories.put("key.categories.misc", new ArrayList());
        this.categories.put("key.categories.controllable_custom", new ArrayList());
        BindingRegistry.getInstance().getBindings().stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
            if (showUnbound && binding.getButton() != -1) {
                return;
            }
            List list = this.categories.computeIfAbsent(binding.getCategory(), category -> new ArrayList());
            list.add(binding);
        });
        this.categories.forEach((category, list) -> {
            if (!list.isEmpty()) {
                Collections.sort(list);
                this.func_230513_b_((AbstractList.AbstractListEntry)new CategoryEntry((ITextComponent)new TranslationTextComponent(category)));
                list.forEach(binding -> this.func_230513_b_((AbstractList.AbstractListEntry)new BindingEntry((ButtonBinding)binding)));
            }
        });
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.parent instanceof ButtonBindingScreen && ((ButtonBindingScreen)this.parent).isWaitingForButtonInput()) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public class BindingEntry
    extends Entry {
        private ButtonBinding binding;
        private TextComponent label;
        private Button bindingButton;
        private Button deleteButton;
        private Button removeButton;

        protected BindingEntry(ButtonBinding binding) {
            this.binding = binding;
            this.label = new TranslationTextComponent(binding.getLabelKey());
            if (ButtonBindingList.this.parent instanceof ButtonBindingScreen) {
                this.bindingButton = new ButtonBindingButton(0, 0, binding, button -> {
                    if (ButtonBindingList.this.parent instanceof ButtonBindingScreen) {
                        ((ButtonBindingScreen)ButtonBindingList.this.parent).setSelectedBinding(this.binding);
                    }
                });
                this.deleteButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 108, 0, 16, 16, button -> {
                    binding.reset();
                    BindingRegistry registry = BindingRegistry.getInstance();
                    registry.resetBindingHash();
                    registry.save();
                });
                this.removeButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 0, 0, 16, 16, button -> {
                    if (binding instanceof KeyAdapterBinding) {
                        BindingRegistry.getInstance().removeKeyAdapter((KeyAdapterBinding)binding);
                    }
                    ButtonBindingList.this.func_230956_e_((AbstractList.AbstractListEntry)this);
                });
                this.removeButton.field_230694_p_ = binding instanceof KeyAdapterBinding;
            } else if (ButtonBindingList.this.parent instanceof SelectButtonBindingScreen) {
                SelectButtonBindingScreen screen = (SelectButtonBindingScreen)ButtonBindingList.this.parent;
                List<ButtonBindingData> bindings = screen.getRadialConfigureScreen().getBindings();
                this.bindingButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 88, 25, 10, 10, button -> {
                    bindings.add(new ButtonBindingData(this.binding, TextFormatting.YELLOW));
                    this.bindingButton.field_230693_o_ = false;
                    this.deleteButton.field_230693_o_ = true;
                });
                this.deleteButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 98, 15, 10, 10, button -> {
                    bindings.removeIf(entry -> entry.getBinding() == this.binding);
                    this.bindingButton.field_230693_o_ = true;
                    this.deleteButton.field_230693_o_ = false;
                });
                this.bindingButton.field_230693_o_ = bindings.stream().noneMatch(entry -> entry.getBinding() == this.binding);
                this.deleteButton.field_230693_o_ = bindings.stream().anyMatch(entry -> entry.getBinding() == this.binding);
            }
        }

        public void updateButtons() {
            if (ButtonBindingList.this.parent instanceof SelectButtonBindingScreen) {
                SelectButtonBindingScreen screen = (SelectButtonBindingScreen)ButtonBindingList.this.parent;
                List<ButtonBindingData> bindings = screen.getRadialConfigureScreen().getBindings();
                this.bindingButton.field_230693_o_ = bindings.stream().noneMatch(entry -> entry.getBinding() == this.binding);
                this.deleteButton.field_230693_o_ = bindings.stream().anyMatch(entry -> entry.getBinding() == this.binding);
            }
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.bindingButton, (Object)this.deleteButton);
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int y, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            int color = this.binding.isConflictingContext() ? TextFormatting.RED.func_211163_e() : TextFormatting.GRAY.func_211163_e();
            ((ButtonBindingList)ButtonBindingList.this).field_230668_b_.field_71466_p.func_243246_a(matrixStack, (ITextComponent)this.label, (float)(left - 15), (float)(y + 6), color);
            this.bindingButton.field_230690_l_ = left + width - 38;
            this.bindingButton.field_230691_m_ = y;
            this.bindingButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.deleteButton.field_230690_l_ = left + width - 15;
            this.deleteButton.field_230691_m_ = y;
            if (ButtonBindingList.this.parent instanceof ButtonBindingScreen) {
                this.deleteButton.field_230693_o_ = !this.binding.isDefault();
            }
            this.deleteButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (ButtonBindingList.this.parent instanceof ButtonBindingScreen && button == 1 && this.bindingButton.func_230449_g_()) {
                this.binding.setButton(-1);
                this.bindingButton.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                return true;
            }
            return super.func_231044_a_(mouseX, mouseY, button);
        }
    }

    protected class CategoryEntry
    extends Entry {
        private final ITextComponent label;
        private final int labelWidth;

        protected CategoryEntry(ITextComponent label) {
            this.label = label;
            this.labelWidth = ((ButtonBindingList)ButtonBindingList.this).field_230668_b_.field_71466_p.func_238414_a_((ITextProperties)this.label);
        }

        public boolean func_231049_c__(boolean focus) {
            return false;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int y, int p_230432_4_, int p_230432_5_, int itemHeight, int p_230432_7_, int p_230432_8_, boolean selected, float partialTicks) {
            float labelX = (float)((ButtonBindingList)ButtonBindingList.this).field_230668_b_.field_71462_r.field_230708_k_ / 2.0f - (float)this.labelWidth / 2.0f;
            float labelY = y + itemHeight - 9 - 1;
            ((ButtonBindingList)ButtonBindingList.this).field_230668_b_.field_71466_p.func_243248_b(matrixStack, this.label, labelX, labelY, -1);
        }
    }

    abstract class Entry
    extends AbstractOptionList.Entry<Entry> {
        Entry() {
        }
    }
}

