/*
 * Decompiled with CFR 0.152.
 */
package sn2.timecraft.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import sn2.timecraft.Constants;

public class ConfigLoader {
    public HashMap<Integer, Float> difficultyMap = new HashMap();
    public static Path cfgPath = Loader.instance().getConfigDir().toPath();
    public static String GLOBAL = "global_multiplier";
    public static String MODS = "mods";
    public static String MOD_MULTIPLIER = "mod_multiplier";
    public static String ITEMS = "items";

    public static void genSampleConfig() {
        HashMap<String, JsonObject> nameSpaceMap = new HashMap<String, JsonObject>();
        ForgeRegistries.ITEMS.getKeys().forEach(rkey -> {
            String namespace = rkey.func_110624_b();
            String path = rkey.func_110623_a();
            if (!nameSpaceMap.containsKey(namespace)) {
                JsonObject array = new JsonObject();
                nameSpaceMap.put(namespace, array);
            }
            ((JsonObject)nameSpaceMap.get(namespace)).addProperty(path, (Number)Float.valueOf(20.0f));
        });
        JsonObject all = new JsonObject();
        all.addProperty(GLOBAL, (Number)Float.valueOf(1.0f));
        JsonObject mod_list = new JsonObject();
        all.add(MODS, (JsonElement)mod_list);
        nameSpaceMap.forEach((name, array) -> {
            JsonObject mod = new JsonObject();
            mod.addProperty(MOD_MULTIPLIER, (Number)Float.valueOf(1.0f));
            mod.add(ITEMS, (JsonElement)array);
            mod_list.add(name, (JsonElement)mod);
        });
        try {
            File cfgSampleFile = cfgPath.resolve(Constants.CONFIG_FILENAME).toFile();
            if (cfgSampleFile.exists()) {
                cfgSampleFile = cfgPath.resolve(Constants.SAMPLE_CONFIG_FILENAME).toFile();
            }
            FileWriter writer = new FileWriter(cfgSampleFile);
            writer.write(all.toString());
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parserFrom(String jsonString) {
        JsonParser parser = new JsonParser();
        JsonObject object = (JsonObject)parser.parse(jsonString);
        float global_multiplier = object.getAsJsonPrimitive(GLOBAL).getAsFloat();
        JsonObject mod_list = object.getAsJsonObject(MODS);
        mod_list.entrySet().forEach(e -> {
            String namespace = (String)e.getKey() + ':';
            JsonObject mod = (JsonObject)e.getValue();
            float mod_multiplier = mod.getAsJsonPrimitive(MOD_MULTIPLIER).getAsFloat() * global_multiplier;
            JsonObject items = mod.getAsJsonObject(ITEMS);
            items.entrySet().forEach(i -> {
                String item = namespace + (String)i.getKey();
                int id = Item.func_150891_b((Item)Item.func_111206_d((String)item));
                float value = ((JsonElement)i.getValue()).getAsFloat() * mod_multiplier;
                this.setDifficulty(id, value);
            });
        });
    }

    public float getDifficulty(Item item) {
        int rkey = Item.func_150891_b((Item)item);
        if (this.difficultyMap.containsKey(rkey)) {
            return this.difficultyMap.get(rkey).floatValue();
        }
        return 20.0f;
    }

    public void setDifficulty(int item, float difficulty) {
        this.difficultyMap.put(item, Float.valueOf(difficulty));
    }
}

