/*
 * Decompiled with CFR 0.152.
 */
package sn2.timecraft.event;

import java.io.File;
import java.io.FileInputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sn2.timecraft.Constants;
import sn2.timecraft.TimeCraft;
import sn2.timecraft.config.ConfigLoader;
import sn2.timecraft.networking.PacketCraftingDifficulty;
import sn2.timecraft.networking.TimeCraftPacketHandler;

@Mod.EventBusSubscriber
public class Events {
    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            ConfigLoader.genSampleConfig();
            try {
                File cfgFile = ConfigLoader.cfgPath.resolve(Constants.CONFIG_FILENAME).toFile();
                FileInputStream inputFile = new FileInputStream(cfgFile);
                byte[] buf = new byte[inputFile.available()];
                inputFile.read(buf);
                inputFile.close();
                String json = new String(buf);
                TimeCraft.map.parserFrom(json);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        TimeCraft.map.difficultyMap.forEach((item, difficulty) -> {
            PacketCraftingDifficulty packet = new PacketCraftingDifficulty((int)item, difficulty.floatValue());
            TimeCraftPacketHandler.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
        });
    }
}

