/*
 * Decompiled with CFR 0.152.
 */
package sn2.timecraft.mixin;

import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.recipebook.GuiRecipeBook;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sn2.timecraft.ITimeCraftPlayer;
import sn2.timecraft.util.CraftingDifficultyHelper;

@Mixin(value={GuiCrafting.class})
public abstract class MixinCraftingScreen
extends GuiContainer
implements IRecipeShownListener {
    @Shadow
    private GuiRecipeBook field_192050_x = new GuiRecipeBook();
    private ITimeCraftPlayer player;
    private static final ResourceLocation CRAFT_OVERLAY_TEXTURE = new ResourceLocation("timecraft:textures/gui/crafting_table.png");

    public MixinCraftingScreen(InventoryPlayer playerInv, World worldIn, BlockPos blockPosition) {
        super((Container)new ContainerWorkbench(playerInv, worldIn, blockPosition));
    }

    @Inject(method={"drawGuiContainerBackgroundLayer"}, at={@At(value="TAIL")}, cancellable=true)
    protected void timecraft$drawGuiContainerBackgroundLayer(float delta, int mouseX, int mouseY, CallbackInfo info) {
        this.player = (ITimeCraftPlayer)this.field_146297_k.field_71439_g;
        this.field_146297_k.func_110434_K().func_110577_a(CRAFT_OVERLAY_TEXTURE);
        int i = this.field_147003_i;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.player.isCrafting() && this.player.getCraftPeriod() > 0.0f) {
            int l = (int)(this.player.getCraftTime() * 24.0f / this.player.getCraftPeriod());
            MixinCraftingScreen.func_146110_a((int)(i + 89), (int)(j + 35), (float)0.0f, (float)0.0f, (int)(l + 1), (int)16, (float)24.0f, (float)17.0f);
        }
    }

    @Inject(method={"updateScreen"}, at={@At(value="TAIL")}, cancellable=true)
    public void timecraft$updateScreen(CallbackInfo info) {
        this.player = (ITimeCraftPlayer)this.field_146297_k.field_71439_g;
        ItemStack resultStack = this.field_147002_h.func_75139_a(0).func_75211_c();
        boolean finished = this.player.tick(resultStack);
        if (finished) {
            ArrayList<Item> old_recipe = CraftingDifficultyHelper.getItemFromMatrix(this.field_147002_h, true);
            super.func_184098_a(this.field_147002_h.func_75139_a(0), 0, 0, ClickType.PICKUP);
            ArrayList<Item> new_recipe = CraftingDifficultyHelper.getItemFromMatrix(this.field_147002_h, true);
            if (old_recipe.equals(new_recipe)) {
                this.player.setCraftPeriod(CraftingDifficultyHelper.getCraftingDifficultyFromMatrix(this.field_147002_h, true));
            } else {
                this.player.stopCraft();
            }
        }
    }

    @Inject(method={"handleMouseClick"}, at={@At(value="HEAD")}, cancellable=true)
    public void timecraft$handleMouseClick(Slot slot, int invSlot, int clickData, ClickType actionType, CallbackInfo info) {
        if (slot != null) {
            invSlot = slot.field_75222_d;
        }
        if (invSlot > 0 && invSlot < 10) {
            this.player.stopCraft();
        }
        if (invSlot == 0) {
            if (!this.player.isCrafting()) {
                this.player.startCraftWithNewPeriod(CraftingDifficultyHelper.getCraftingDifficultyFromMatrix(this.field_147002_h, true));
            }
            info.cancel();
        }
    }

    @Inject(method={"onGuiClosed"}, at={@At(value="HEAD")}, cancellable=true)
    public void timecraft$onClose(CallbackInfo info) {
        this.player.stopCraft();
    }
}

