/*
 * Decompiled with CFR 0.152.
 */
package sn2.timecraft.mixin;

import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sn2.timecraft.ITimeCraftPlayer;
import sn2.timecraft.util.CraftingDifficultyHelper;

@Mixin(value={GuiInventory.class})
public abstract class MixinInventoryScreen
extends InventoryEffectRenderer
implements IRecipeShownListener {
    private ITimeCraftPlayer player;
    private static final ResourceLocation CRAFT_OVERLAY_TEXTURE = new ResourceLocation("timecraft:textures/gui/inventory.png");

    public MixinInventoryScreen(EntityPlayer player) {
        super(player.field_71069_bz);
        this.field_146291_p = true;
    }

    @Inject(method={"drawGuiContainerBackgroundLayer"}, at={@At(value="TAIL")}, cancellable=true)
    protected void timecraft$drawGuiContainerBackgroundLayer(float delta, int mouseX, int mouseY, CallbackInfo info) {
        this.player = (ITimeCraftPlayer)this.field_146297_k.field_71439_g;
        this.field_146297_k.func_110434_K().func_110577_a(CRAFT_OVERLAY_TEXTURE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        if (this.player.isCrafting() && this.player.getCraftPeriod() > 0.0f) {
            int l = (int)(this.player.getCraftTime() * 17.0f / this.player.getCraftPeriod());
            MixinInventoryScreen.func_146110_a((int)(i + 134), (int)(j + 29), (float)0.0f, (float)0.0f, (int)(l + 1), (int)14, (float)18.0f, (float)15.0f);
        }
    }

    @Inject(method={"updateScreen"}, at={@At(value="TAIL")}, cancellable=true)
    public void timecraft$updateScreen(CallbackInfo info) {
        this.player = (ITimeCraftPlayer)this.field_146297_k.field_71439_g;
        ItemStack resultStack = this.field_147002_h.func_75139_a(0).func_75211_c();
        boolean finished = this.player.tick(resultStack);
        if (finished) {
            ArrayList<Item> old_recipe = CraftingDifficultyHelper.getItemFromMatrix(this.field_147002_h, false);
            super.func_184098_a(this.field_147002_h.func_75139_a(0), 0, 0, ClickType.PICKUP);
            ArrayList<Item> new_recipe = CraftingDifficultyHelper.getItemFromMatrix(this.field_147002_h, false);
            if (old_recipe.equals(new_recipe)) {
                this.player.setCraftPeriod(CraftingDifficultyHelper.getCraftingDifficultyFromMatrix(this.field_147002_h, false));
            } else {
                this.player.stopCraft();
            }
        }
    }

    @Inject(method={"handleMouseClick"}, at={@At(value="HEAD")}, cancellable=true)
    public void timecraft$handleMouseClick(Slot slot, int invSlot, int clickData, ClickType actionType, CallbackInfo info) {
        if (slot != null) {
            invSlot = slot.field_75222_d;
        }
        if (invSlot > 0 && invSlot < 5) {
            this.player.stopCraft();
        }
        if (invSlot == 0) {
            if (!this.player.isCrafting()) {
                this.player.startCraftWithNewPeriod(CraftingDifficultyHelper.getCraftingDifficultyFromMatrix(this.field_147002_h, false));
            }
            info.cancel();
        }
    }

    @Inject(method={"onGuiClosed"}, at={@At(value="HEAD")}, cancellable=true)
    public void timecraft$onClose(CallbackInfo info) {
        if (this.player != null) {
            this.player.stopCraft();
        }
    }
}

