/*
 * Decompiled with CFR 0.152.
 */
package sn2.timecraft.mixin;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import sn2.timecraft.ITimeCraftPlayer;

@Mixin(value={ClientPlayerEntity.class})
public class MixinClientPlayerEntity
extends AbstractClientPlayerEntity
implements ITimeCraftPlayer {
    public boolean is_crafting = false;
    public float craft_time = 0.0f;
    public float craft_period = 0.0f;

    public MixinClientPlayerEntity(ClientWorld world, GameProfile profile) {
        super(world, profile);
    }

    @Override
    public void setCrafting(boolean is_crafting) {
        this.is_crafting = is_crafting;
    }

    @Override
    public boolean isCrafting() {
        return this.is_crafting;
    }

    @Override
    public void setCraftTime(float craft_time) {
        this.craft_time = craft_time;
    }

    @Override
    public float getCraftTime() {
        return this.craft_time;
    }

    @Override
    public void setCraftPeriod(float craft_period) {
        this.craft_period = craft_period;
    }

    @Override
    public float getCraftPeriod() {
        return this.craft_period;
    }

    @Override
    public void stopCraft() {
        this.is_crafting = false;
        this.craft_time = 0.0f;
    }

    @Override
    public void startCraftWithNewPeriod(float craft_period) {
        this.craft_period = craft_period;
        this.is_crafting = true;
    }

    @Override
    public boolean tick(ItemStack resultStack) {
        if (this.isCrafting()) {
            ItemStack cursorStack = this.field_71071_by.func_70445_o();
            if (!(cursorStack.func_77973_b() == Items.field_190931_a || cursorStack.func_77969_a(resultStack) && cursorStack.func_190916_E() + resultStack.func_190916_E() <= cursorStack.func_77976_d())) {
                this.stopCraft();
            }
            if (this.getCraftTime() < this.getCraftPeriod()) {
                this.craft_time += 1.0f + 0.02f * (float)Math.min(this.field_71068_ca, 200);
            }
            if (this.getCraftTime() >= this.getCraftPeriod()) {
                this.craft_time = 0.0f;
                return true;
            }
        }
        return false;
    }
}

