/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.block.IBlockVertexColor;
import com.simibubi.create.foundation.block.render.ColoredVertexModel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GrassColors;
import net.minecraft.world.ILightReader;
import net.minecraft.world.biome.BiomeColors;

public class AllColorHandlers {
    private final Map<Block, IBlockVertexColor> coloredVertexBlocks = new HashMap<Block, IBlockVertexColor>();
    private final Map<Block, IBlockColor> coloredBlocks = new HashMap<Block, IBlockColor>();
    private final Map<IItemProvider, IItemColor> coloredItems = new HashMap<IItemProvider, IItemColor>();

    public static IBlockColor getGrassyBlock() {
        return new BlockColor((state, world, pos, layer) -> pos != null && world != null ? BiomeColors.func_228358_a_((ILightReader)world, (BlockPos)pos) : GrassColors.func_77480_a((double)0.5, (double)1.0));
    }

    public static IItemColor getGrassyItem() {
        return new ItemColor((stack, layer) -> GrassColors.func_77480_a((double)0.5, (double)1.0));
    }

    public static IBlockColor getRedstonePower() {
        return new BlockColor((state, world, pos, layer) -> RedstoneWireBlock.func_176337_b((int)(pos != null && world != null ? (Integer)state.func_177229_b((IProperty)BlockStateProperties.field_208136_ak) : 0)));
    }

    public void register(Block block, IBlockColor color) {
        this.coloredBlocks.put(block, color);
    }

    public void register(Block block, IBlockVertexColor color) {
        this.coloredVertexBlocks.put(block, color);
    }

    public void register(IItemProvider item, IItemColor color) {
        this.coloredItems.put(item, color);
    }

    public void init() {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        this.coloredBlocks.forEach((block, color) -> blockColors.func_186722_a(color, new Block[]{block}));
        this.coloredItems.forEach((item, color) -> itemColors.func_199877_a(color, new IItemProvider[]{item}));
        this.coloredVertexBlocks.forEach((block, color) -> CreateClient.getCustomBlockModels().register(() -> block, (IBakedModel model) -> new ColoredVertexModel((IBakedModel)model, (IBlockVertexColor)color)));
    }

    private static class BlockColor
    implements IBlockColor {
        private Function function;

        public BlockColor(Function function) {
            this.function = function;
        }

        public int getColor(BlockState state, ILightReader world, BlockPos pos, int layer) {
            return this.function.apply(state, world, pos, layer);
        }

        @FunctionalInterface
        static interface Function {
            public int apply(BlockState var1, ILightReader var2, BlockPos var3, int var4);
        }
    }

    private static class ItemColor
    implements IItemColor {
        private Function function;

        public ItemColor(Function function) {
            this.function = function;
        }

        public int getColor(ItemStack stack, int layer) {
            return this.function.apply(stack, layer);
        }

        @FunctionalInterface
        static interface Function {
            public int apply(ItemStack var1, int var2);
        }
    }
}

