/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.BasinCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.compat.jei.category.animations.AnimatedMixer;
import com.simibubi.create.content.contraptions.processing.BasinRecipe;
import com.simibubi.create.content.contraptions.processing.HeatCondition;
import net.minecraft.block.Blocks;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class MixingCategory
extends BasinCategory {
    private final AnimatedMixer mixer = new AnimatedMixer();
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();
    MixingType type;

    public static MixingCategory autoShapeless() {
        return new MixingCategory(MixingType.AUTO_SHAPELESS, (IItemProvider)Items.field_221734_cc, 85);
    }

    public static MixingCategory standard() {
        return new MixingCategory(MixingType.MIXING, (IItemProvider)AllBlocks.BASIN.get(), 103);
    }

    public static MixingCategory autoBrewing() {
        return new MixingCategory(MixingType.AUTO_BREWING, (IItemProvider)Blocks.field_150382_bo, 103);
    }

    protected MixingCategory(MixingType type, IItemProvider secondaryItem, int height) {
        super(type != MixingType.AUTO_SHAPELESS, MixingCategory.doubleItemIcon((IItemProvider)AllBlocks.MECHANICAL_MIXER.get(), secondaryItem), MixingCategory.emptyBackground(177, height));
        this.type = type;
    }

    @Override
    public void draw(BasinRecipe recipe, double mouseX, double mouseY) {
        super.draw(recipe, mouseX, mouseY);
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (requiredHeat != HeatCondition.NONE) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(this.getBackground().getWidth() / 2 + 3, 55);
        }
        this.mixer.draw(this.getBackground().getWidth() / 2 + 3, 34);
    }

    static enum MixingType {
        AUTO_SHAPELESS,
        MIXING,
        AUTO_BREWING;

    }
}

