/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category.animations;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.util.Direction;

public class AnimatedPress
extends AnimatedKinetics {
    private boolean basin;

    public AnimatedPress(boolean basin) {
        this.basin = basin;
    }

    public void draw(int xOffset, int yOffset) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)xOffset, (float)yOffset, (float)100.0f);
        RenderSystem.rotatef((float)-15.5f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.rotatef((float)22.5f, (float)0.0f, (float)1.0f, (float)0.0f);
        int scale = this.basin ? 20 : 24;
        GuiGameElement.of(this.shaft(Direction.Axis.Z)).rotateBlock(0.0, 0.0, AnimatedPress.getCurrentAngle()).scale(scale).render();
        GuiGameElement.of(AllBlocks.MECHANICAL_PRESS.getDefaultState()).scale(scale).render();
        GuiGameElement.of(AllBlockPartials.MECHANICAL_PRESS_HEAD).atLocal(0.0, -this.getAnimatedHeadOffset(), 0.0).scale(scale).render();
        if (this.basin) {
            GuiGameElement.of(AllBlocks.BASIN.getDefaultState()).atLocal(0.0, 1.65, 0.0).scale(scale).render();
        }
        RenderSystem.popMatrix();
    }

    private float getAnimatedHeadOffset() {
        float cycle = AnimationTickHolder.getRenderTime() % 30.0f;
        if (cycle < 10.0f) {
            float progress = cycle / 10.0f;
            return -(progress * progress * progress);
        }
        if (cycle < 15.0f) {
            return -1.0f;
        }
        if (cycle < 20.0f) {
            return -1.0f + (1.0f - (20.0f - cycle) / 5.0f);
        }
        return 0.0f;
    }
}

